/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o1zy
 */

package {
    import flash.media.Video;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    import flash.display.Graphics;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var sp:Sprite;
        private var gr:Graphics;
        private var vertices:Vector.<Vector3D>;
        private var vertices2D:Vector.<Point>;
        private var indices:Vector.<Vector.<uint>>;
        
        private var nUnit:Number = 50;
        private var nD:Number = 0.3;
        private var nF:Number = nUnit * 10;
        public function FlashTest() {
            // write as3 code here..
            vertices = new Vector.<Vector3D>();
            indices = new Vector.<Vector.<uint>>();
            
            sp = new Sprite();
            gr = sp.graphics;
            addChild(sp);
            sp.x = stage.stageWidth / 2;
            sp.y = stage.stageHeight / 2;
            
            vertices.push(new Vector3D(-nUnit, -nUnit, -nUnit));
            vertices.push(new Vector3D(nUnit, -nUnit, -nUnit));
            vertices.push(new Vector3D(nUnit, nUnit, -nUnit));
            vertices.push(new Vector3D(-nUnit, nUnit, -nUnit));
            vertices.push(new Vector3D(-nUnit, -nUnit, nUnit));
            vertices.push(new Vector3D(nUnit, -nUnit, nUnit));
            vertices.push(new Vector3D(nUnit, nUnit, nUnit));
            vertices.push(new Vector3D(-nUnit, nUnit, nUnit));
            
            indices.push(Vector.<uint>([0, 1, 2, 3]));
            indices.push(Vector.<uint>([4, 5, 6, 7]));
            indices.push(Vector.<uint>([0, 4]));
            indices.push(Vector.<uint>([1, 5]));
            indices.push(Vector.<uint>([2, 6]));
            indices.push(Vector.<uint>([3, 7]));
            
            vertices2D = xGetVertices2D(vertices);
            xDrawLines(vertices2D);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            var nR:Point = new Point(sp.mouseX * nD, sp.mouseY * nD);
            xTransform(vertices, nR);
            var v2D:Vector.<Point> = xGetVertices2D(vertices);
            xDraw(v2D, indices);
        }
        
        private function xTransform(v:Vector.<Vector3D>, r:Point):void
        {
            var nL:uint = v.length;
            var m3D:Matrix3D = new Matrix3D();
            
            m3D.appendRotation(r.x, Vector3D.Y_AXIS);
            m3D.appendRotation(r.y, Vector3D.X_AXIS);
            
            for(var i:uint = 0;i < nL;i++)
            {
                v[i] = m3D.transformVector(v[i]);
            }

        }


        private function xGetVertices2D(v:Vector.<Vector3D>):Vector.<Point>
        {
            var v2D:Vector.<Point> = new Vector.<Point>();
            var nLength:uint = v.length;
            for(var i:uint = 0;i < nLength;i++)
            {
                var v3D:Vector3D = v[i].clone();
                v3D.w = (nF + v3D.z) / nF;
                v3D.project();
                v2D.push(new Point(v3D.x, v3D.y));
            }
            
            return v2D;

        }
        
        private function xDraw(v2D:Vector.<Point>, ind:Vector.<Vector.<uint>>):void
        {
            var nL:uint = ind.length;
            gr.clear();
            for(var i:uint = 0;i < nL;i++)
            {
                var v:Vector.<Point> = new Vector.<Point>();
                var index:Vector.<uint> = ind[i];
                var nL2:uint = index.length;
                for(var j:uint = 0;j < nL2;j++)
                {
                    v.push(v2D[index[j]]);
                }
                
                xDrawLines(v);
            }

        }

        
        private function xDrawLines(v2D:Vector.<Point>):void
        {
            var nL:uint = v2D.length;
            var p:Point = v2D[nL - 1];
            
            if(nL < 3)
            {
                --nL;
            }

            gr.lineStyle(2, 0);
            gr.moveTo(p.x, p.y);
            for(var i:uint = 0;i < nL;i++)
            {
                p = v2D[i];
                gr.lineTo(p.x, p.y);
            }

        }


    }
}