/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o0o3
 */

package
{
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    
    public class Rotation extends Sprite
    {
        private var rot:Number = 0;
        private var length:Number = 100;
        private var offsetX:Number = 0;
        private var offsetY:Number = 0;
        
        public function Rotation()
        {            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            offsetX = stage.stageWidth * .5;
            offsetY = stage.stageHeight * .5;
            
            var lock:Point = new Point(stage.stageWidth * .5, stage.stageHeight * .5);
            var source:Point = new Point(130, 100);
            draw(lock, source, 0xff0000);
            draw(lock, calc(source, lock, 100), 0x00ff00);
            draw(lock, calc(source, lock, 50), 0x0000ff);
        }
        
        private function draw(p0:Point, p1:Point, color:uint):void
        {
            graphics.lineStyle(0, color);
            graphics.moveTo(p0.x, p0.y);
            graphics.lineTo(p1.x, p1.y);
        }
        
        private function calc(source:Point, lock:Point, rotation:Number):Point
        {
            var dx:Number = source.x - lock.x;
            var dy:Number = source.y - lock.y;
            var distance:Number = Math.sqrt(dx * dx + dy * dy);
            var rad:Number = rotation * Math.PI / 180 + Math.atan2(dx, -dy);
            return new Point(
                Math.sin(rad) * distance + lock.x, 
                -Math.cos(rad) * distance + lock.y);
        }

    }
}