/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o0hs
 */

package  
{
    import com.bit101.components.Text;
    import flash.display.Sprite;
    import flash.text.*;
    import net.user1.logger.*;
    import net.user1.reactor.*;
    import flash.events.*;
  
    public class TryUnion3 extends Sprite
    {
        private var _reactor:Reactor;
        private var _room:Room;
        private var _logger:Logger;
        private var _textField:TextField;

        public function TryUnion3() {
            _textField = new TextField();
            _textField.defaultTextFormat = new TextFormat("_等幅", 10);
            _textField.width = _textField.height = 465;
            _textField.wordWrap = true;
            addChild(_textField);
            
            _reactor = new Reactor();
            _reactor.addEventListener(ReactorEvent.READY, _reactor_readyHandler);
            
            _logger = _reactor.getLog();
            _logger.addEventListener(LogEvent.UPDATE, _logger_updateHandler);//ログ情報更新イベント
            
            
            _reactor.connect("localhost", 9100);
            //_reactor.connect("ozmap.orz.hm",9100);
        }
        
        private function _reactor_readyHandler(event:ReactorEvent):void {
            _room = _reactor.getRoomManager().createRoom("test22");//ルーム作成 
            _room.addEventListener(RoomEvent.JOIN, _room_joinHandler);
            _room.addMessageListener("shared", _room_sharedHandler);
            _room.join();
        }
        
        private function activate():void {
            stage.addEventListener( MouseEvent.CLICK, stage_mouseClickHandler );
        }
 
        private function _room_joinHandler(event:RoomEvent):void {
            activate();
        }
        
        //メッセージイベント
        private function _room_sharedHandler(
                fromClient:IClient, color:uint,
                sharedX:Number, sharedY:Number):void
        {
            graphics.beginFill(color);
            graphics.drawCircle(sharedX, sharedY, 10);//円描画
 
            var textField:TextField = new TextField();
            textField.autoSize = TextFieldAutoSize.LEFT;
            textField.text = fromClient.getClientID();
            textField.x = sharedX;
            textField.y = sharedY;
            textField.mouseEnabled = false;
            addChild(textField);
        }
        
        private function stage_mouseClickHandler(event:MouseEvent):void
        {
            // Roomに色とマウスのｘ座標、ｙ座標を引数とした shared　という名の
            //　メッセージを送信します
            _room.sendMessage( "shared", true, null, 
                0x777777 + 0x888888 * Math.random(),
                event.stageX, event.stageY
            );
        } 
        
        //ログ描画
        private function _logger_updateHandler(event:LogEvent):void {
            _textField.appendText(
                "[" + event.getLevel() + "]" + event.getMessage() + "\n");
            _textField.scrollV = _textField.maxScrollV;
            
        }
    }
}