/**
 * Copyright BarnabyByrne ( http://wonderfl.net/user/BarnabyByrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o05B
 */

package 
{
    // CLASSES
    
    // CubeTest
    // player
    // enemy1 - "skinny malink"
    // coin
    // particle
    // bullet
    // text
    
    // IMPORTS
    import flash.ui.Keyboard;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;    

    // INITIALISATION
    [SWF (width="640", height="480", framerate="60", quality="low")]

    public class CubeTest extends Sprite 
    {
        // Global variables
        public var keyArray:Array=[];
        public var score:int=0;
        public var pauseCooloff:int=0;
        public var paused:Boolean=false;

        // Game states
        public var state:int=0;        
        public const MENU:int=0;
        public const GAMELOOP:int=1;
        public const PAUSED:int=2;
        public const GAMEOVER:int=3;

        // Character text types
        // 26 Upper case letters
        // 10 Digits
        // 1 Space
        public const TOTAL_TXT_CHARS:int=26+10+1;
        public const CHAR_UPPR:int=0;
        public const CHAR_SPACE:int=1;
        public const CHAR_DIGIT:int=2;

        public const TXT_SIZE_LARGE:int=0;
        public const TXT_SIZE_REGULAR:int=1;

        // Object pools
        public var coinPool:Array=[];
        public var particlePool:Array=[];
        public var enemyPool:Array=[];

        public const MAX_COINS:int=50;
        public const MAX_PARTICLES:int=400;
        public const MAX_ENEMIES:int=100;

        public var currentCoin:int=0;
        public var currentParticle:int=0;
        public var currentEnemy:int=0;

        // Counters
        public var i:int=0;
        public var j:int=0;
        public var k:int=0;
        public var l:int=0;

        // Keycode Constants
        public const KEYUP:int=38;
        public const KEYDN:int=40;
        public const KEYLT:int=37;
        public const KEYRT:int=39;
        public const SPACE:int=32;
        public const PAUSE:int=80;

        // Player
        public var p:Player=new Player();

        // Text
        public var t:Text=new Text();

        // Canvas
        public var singlePixel:BitmapData=new BitmapData(4,4,false,0xCCDDEE);
        public var blitRect:Rectangle=new Rectangle(0,0,640,480);
        public var blitPoint:Point=new Point(0,0);
        public var canvasRect:Rectangle=new Rectangle(0,0,640,480);
        public var canvasBmpData:BitmapData=new BitmapData(640,480,false,0x000000);
        public var canvasBgData:BitmapData=new BitmapData(640,480,false,0x000000);
        public var canvasPoint:Point=new Point(0,0);
        public var canvas:Bitmap;
        public var randColor:uint = Math.random() * 0xFFFFFF;

        // CONSTRUCTOR
        public function CubeTest()
        {
            // Setup object pools
            createCoinPool();
            createParticlePool();
            canvas=new Bitmap(canvasBmpData);
            addChild(canvas);
            //stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyPress);
            stage.addEventListener(KeyboardEvent.KEY_UP,keyRelease);
            addEventListener(Event.ENTER_FRAME,mainLoop);
        }

        // CREATE POOLS
        public function createCoinPool():void
        {
            for(i=0;i<MAX_COINS;i++)
            {
                var tmpCoin:Coin=new Coin();
                tmpCoin.x=Math.random()*600+20;
                tmpCoin.y=Math.random()*400+40;
                coinPool.push(tmpCoin);
            }
        }
        public function createParticlePool():void
        {
            for(i=0;i<MAX_PARTICLES;i++)
            {
                var tmpParticle:Particle=new Particle();
                tmpParticle.x=-2000;
                tmpParticle.y=0;
                particlePool.push(tmpParticle);
            }
        }

        // MAIN LOOP
        public function mainLoop(evt:Event):void
        {
            if(state==MENU)
            {
             renderTxt("BLITDEMO BASIC GAME",5,5,4,1);
             renderTxt("PRESS SPACE TO START",5,40,3,2);            
             if(keyArray[SPACE])
             state=GAMELOOP;                        
            }
            else if (state==GAMELOOP)
            {
             if(pauseCooloff>0) pauseCooloff--;
             if(!paused && pauseCooloff==0 && keyArray[PAUSE]) { paused=true;  pauseCooloff=6; }
             if(paused && pauseCooloff==0 && keyArray[PAUSE])  { paused=false; pauseCooloff=6; }
             if(!paused)
             {
              keyCheck();
              update();
              render();
              collisions();
             }
            }
        }

        // UPDATE
        public function update():void
        {
            // UPDATE COINS 
            for(i=0;i<MAX_COINS;i++)
            {
                if(++coinPool[i].animTimer>6)
                {
                 coinPool[i].animFrame++;
                 if(coinPool[i].animFrame>3)coinPool[i].animFrame=0;
                 coinPool[i].animTimer=0;
                }
            }
        }

        // RENDER
        public function render():void
        {
            canvasBmpData.lock();
            canvasBmpData.copyPixels(canvasBgData,canvasRect,canvasPoint);
            // player
            for(i=0;i<8;i++)
            {
             for(j=0;j<8;j++)
             {
              p.copyPoint.x=i*4;p.copyPoint.y=j*4;
              randColor = Math.random() * 0xFFFFFF;
              singlePixel=new BitmapData(4,4,false,randColor);              
              if(p.fr1[j*8+i]==1)
              {p.bmpData.copyPixels(singlePixel,p.pixelRect,p.copyPoint);}
             }
            }
            blit(p.bmpData,p.x,p.y);
            // coins
            for(i=0;i<MAX_COINS;i++)
            {
                blit(coinPool[i].bmpDataStrip[coinPool[i].animFrame],coinPool[i].x,coinPool[i].y);
            }
            // particles
            for(i=0;i<MAX_PARTICLES;i++)
            {
                blit(particlePool[i].bmpData,particlePool[i].x,particlePool[i].y);
                particlePool[i].x+=particlePool[i].xv;particlePool[i].y+=particlePool[i].yv;
            }
            // text
            renderTxt("COLLECT ALL COINS",5,432,3,3);
            renderTxt("AVOID ALL SPIKES",5,455,3,3); 
            renderTxt("SCORE " + (score),5,5,3,3); 
            //renderTxt("45",50,300,3,3);        
            canvasBmpData.unlock();
        }
        
        // COLLISIONS
        public function collisions():void
        {
            var playerSize:int=32;
            var coinSize:int=24;
            // coins-player
            for(i=0;i<MAX_COINS;i++)
            {
                //test coin above
                if(
                     p.x>coinPool[i].x-22 && p.x<coinPool[i].x+22
                     &&
                     p.y>coinPool[i].y-22 && p.y<coinPool[i].y+22
                   )
                   {
                       coinPool[i].x=-2000;
                       score+=20;
                       for(i=0;i<50;i++)
                       {
                           if(++currentParticle>MAX_PARTICLES) currentParticle=0;
                           particlePool[currentParticle].x=p.x+16;
                           particlePool[currentParticle].y=p.y+16;
                           particlePool[currentParticle].xv=-8+Math.random()*16;
                           particlePool[currentParticle].yv=-8+Math.random()*16;
                           var minSpeed:Number=0.3;
                           if(particlePool[currentParticle].xv<=0 && particlePool[currentParticle].xv>=-minSpeed) 
                            particlePool[currentParticle].xv=-minSpeed; 
                           if(particlePool[currentParticle].yv<=0 && particlePool[currentParticle].yv>=-minSpeed) 
                            particlePool[currentParticle].yv=-minSpeed; 
                           if(particlePool[currentParticle].xv>=0 && particlePool[currentParticle].xv<=minSpeed) 
                            particlePool[currentParticle].xv=minSpeed;   
                           if(particlePool[currentParticle].yv>=0 && particlePool[currentParticle].yv<=minSpeed) 
                            particlePool[currentParticle].yv=minSpeed; 
                       }
                   }
            }
        }

        // RENDER TXT
        public function renderTxt(st:String,x:int,y:int,size:int,flash:int):void
        {
            // Need to determine previous character for letter spacing

            // keycodes 47-57 = digits
            // 32 = space
            // letters: 65-90
            
            var keyCode:int;
            var prevKeyCode:int;
            var charType:int;
            var prevCharType:int;            
            var indx:int;
            var prevIndx:int;

            if(flash==2)
            {
                randColor = Math.random() * 0xFFFFFF; singlePixel=new BitmapData(4,4,false,randColor);
            }
            var offset:int=0;

            for(i=0;i<st.length;i++)
            {
             // Current character type?
             keyCode=st.charCodeAt(i);
             if(keyCode>=47 && keyCode<=57) charType=CHAR_DIGIT;
             if(keyCode>=65 && keyCode<=90) charType=CHAR_UPPR;
             if(keyCode==32) charType=CHAR_SPACE;
             
             // Previous character type
             if(i>0)
             {
              prevKeyCode=st.charCodeAt(i-1);
              if(prevKeyCode>=47 && keyCode<=57) prevCharType=CHAR_DIGIT;
              if(prevKeyCode>=65 && keyCode<=90) prevCharType=CHAR_UPPR;
              if(prevKeyCode==32) prevCharType=CHAR_SPACE;
             }

             if(flash==3)
             {
                randColor = Math.random() * 0xFFFFFF; singlePixel=new BitmapData(4,4,false,randColor);
             }

             if(charType==CHAR_UPPR)  indx=keyCode-65;
             if(charType==CHAR_DIGIT) indx=keyCode-47+26;
             if(charType==CHAR_SPACE) indx=26;

             if(prevCharType==CHAR_UPPR)  prevIndx=prevKeyCode-65;
             if(prevCharType==CHAR_DIGIT) prevIndx=prevKeyCode-47+26;
             if(prevCharType==CHAR_SPACE) prevIndx=26;

             offset+=t.widths[prevIndx];

             if(indx>=0 && indx<=TOTAL_TXT_CHARS)
             {
              for(j=0;j<8;j++)
              {
               for(k=0;k<8;k++)
               {
                if(flash==1)
                {
                 randColor = Math.random() * 0xFFFFFF; singlePixel=new BitmapData(4,4,false,randColor);
                }
                if(t.txtArray[indx][j][k]==1)
                { blit(singlePixel,x+(offset*size)+(j*size),y+(k*size)); }
               }
              }
             }
            }
        }

        // BLIT
        public function blit(img:BitmapData,x:Number,y:Number):void
        {
            blitRect.x=0; blitRect.y=0;
            blitPoint.x=x; blitPoint.y=y;
            blitRect.width=img.width; blitRect.height=img.height;
            canvasBmpData.copyPixels(img,blitRect,blitPoint);
        }

        // KEY CHECK
        public function keyCheck():void
        {
            if (keyArray[KEYLT]) {p.x-=4;}
            if (keyArray[KEYRT]) {p.x+=4;}
            if (keyArray[KEYUP]) {p.y-=4;}
            if (keyArray[KEYDN]) {p.y+=4;}          
        }

        // KEYBOARD PRESS
        public function keyPress(evt:KeyboardEvent):void { keyArray[evt.keyCode]=true; }
        // KEYBOARD RELEASE
        public function keyRelease(evt:KeyboardEvent):void { keyArray[evt.keyCode]=false; }
    }
}
   
import flash.display.*;
import flash.geom.*;

class Player
{
    public var singlePixel:BitmapData;
    public var bmpData:BitmapData;
    public var copyPoint:Point=new Point(0,0);
    public var playerRect:Rectangle=new Rectangle(0,0,16,16);
    public var pixelRect:Rectangle=new Rectangle(0,0,4,4);

    public var x:Number=0.0;
    public var y:Number=0.0;
    public var xv:Number=8.0;
    public var yv:Number=8.0;

    public var pixelWidth:int=8;
    public var pixelHeight:int=8;

    public var i:int=0;
    public var j:int=0;

    // Frame 1
    public var fr1:Array=[0,0,1,1,1,1,0,0,
                          0,1,0,0,0,0,1,0,
                          1,0,0,0,1,0,0,1,
                          1,0,0,0,0,0,0,1,
                          1,0,0,0,0,0,0,1,
                          1,0,0,0,1,0,0,1,
                          0,1,0,0,0,0,1,0,
                          0,0,1,1,1,1,0,0]; 
                       
    // CONSTRUCTOR
    public function Player()
    {
        singlePixel=new BitmapData(4,4,false,0xCCDDEE);
        bmpData=new BitmapData(32,32,true,0x000000);
        copyPoint.x=2;
        copyPoint.y=2;  

        for(i=0;i<8;i++)
        {
         for(j=0;j<8;j++)
         {
          copyPoint.x=i*4;copyPoint.y=j*4;
          if(fr1[j*8+i]==1)
          {bmpData.copyPixels(singlePixel,pixelRect,copyPoint);}
         }
        }
        x=200;y=200;
    }
}

import flash.display.*;
import flash.geom.*;

class SkinnyMalink
{
    public var singlePixel:BitmapData;
    public var bmpData:BitmapData;
    public var copyPoint:Point=new Point(0,0);
    public var bmpRect:Rectangle=new Rectangle(0,0,16,16);
    public var pixelRect:Rectangle=new Rectangle(0,0,4,4);
    public var bmpDataStrip:Array=[];

    public var x:Number=0.0;
    public var y:Number=0.0;
    public var xv:Number=8.0;
    public var yv:Number=8.0;

    public var pixelWidth:int=6;
    public var pixelHeight:int=6;
    public const sizeOfPixels:int=2;

    public var i:int=0;
    public var j:int=0;

    public var animFrame:int=0;
    public var animTimer:int=0;

     // Frame 1
     var fr1:Array=[0,0,0,1,1,0,0,0,
                    0,0,1,0,0,1,0,0,
                    0,0,0,1,1,0,0,0,
                    0,1,1,1,1,1,1,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,0,0,1,0,0,
                    0,0,1,0,0,1,0,0,
                    0,0,1,0,0,1,0,0];
     // Frame 2
     var fr2:Array=[0,0,0,1,1,0,0,0,
                    0,0,1,0,0,1,0,0,
                    0,0,0,1,1,0,0,0,
                    1,1,1,1,1,1,1,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,0,0,1,0,0,
                    0,0,1,0,0,1,0,0,
                    0,1,0,0,0,0,1,0];

    // Malogeon Legs Constructor
    public function Skinnymalink()
    {
        singlePixel=new BitmapData(pixelWidth,pixelHeight,false,0xCCDDEE);
        bmpData=new BitmapData(pixelWidth*sizeOfPixels,pixelHeight*sizeOfPixels,true,0x000000);
        copyPoint.x=2;
        copyPoint.y=2;

        animFrame=Math.random()*3;
        animTimer=Math.random()*10;

        //cacheFrame(fr1);
        //cacheFrame(fr2);
        //cacheFrame(fr3);
        //cacheFrame(fr4);       
    }

     // CACHE
    public function cacheFrame(binaryArray:Array):void
    {
        bmpData=new BitmapData(pixelWidth*4,pixelHeight*4,true,0x000000);
        for(i=0;i<6;i++)
        {
         for(j=0;j<6;j++)
         {
          copyPoint.x=i*4;copyPoint.y=j*4;
          if(binaryArray[j*6+i]==1)
          {bmpData.copyPixels(singlePixel,pixelRect,copyPoint);}
         }
        }
        bmpDataStrip.push(bmpData);
    }
}

import flash.display.*;
import flash.geom.*;

class Coin
{
    public var singlePixel:BitmapData;
    public var bmpData:BitmapData;
    public var copyPoint:Point=new Point(0,0);
    public var playerRect:Rectangle=new Rectangle(0,0,16,16);
    public var pixelRect:Rectangle=new Rectangle(0,0,4,4);
    public var bmpDataStrip:Array=[];

    public var x:Number=0.0;
    public var y:Number=0.0;
    public var xv:Number=8.0;
    public var yv:Number=8.0;

    public var pixelWidth:int=6;
    public var pixelHeight:int=6;

    public var i:int=0;
    public var j:int=0;

    public var animFrame:int=0;
    public var animTimer:int=0;

    // Frame 1
    public var fr1:Array=[0,0,1,1,0,0,
                          0,1,0,0,1,0,
                          1,0,0,0,0,1,
                          1,0,0,0,0,1,
                          0,1,0,0,1,0,
                          0,0,1,1,0,0];

    // Frame 2
    public var fr2:Array=[0,0,1,1,0,0,
                          0,1,0,0,1,0,
                          0,1,0,0,1,0,
                          0,1,0,0,1,0,
                          0,1,0,0,1,0,
                          0,0,1,1,0,0];

    // Frame 3
    public var fr3:Array=[0,0,1,1,0,0,
                          0,0,1,1,0,0,
                          0,0,1,1,0,0,
                          0,0,1,1,0,0,
                          0,0,1,1,0,0,
                          0,0,1,1,0,0];

    // Frame 4
    public var fr4:Array=[0,0,1,1,0,0,
                          0,1,0,0,1,0,
                          0,1,0,0,1,0,
                          0,1,0,0,1,0,
                          0,1,0,0,1,0,
                          0,0,1,1,0,0];

    // CONSTRUCTOR
    public function Coin()
    {
        singlePixel=new BitmapData(4,4,false,0xCCDDEE);
        bmpData=new BitmapData(pixelWidth*4,pixelHeight*4,true,0x000000);
        copyPoint.x=2;
        copyPoint.y=2;

        animFrame=Math.random()*3;
        animTimer=Math.random()*10;

        cacheFrame(fr1);
        cacheFrame(fr2);
        cacheFrame(fr3);
        cacheFrame(fr4);
        
        for(i=0;i<6;i++)
        {
         for(j=0;j<6;j++)
         {
          copyPoint.x=i*4;copyPoint.y=j*4;
          var randColor:uint = Math.random() * 0xFFFFFF; singlePixel=new BitmapData(pixelWidth*4,pixelHeight*4,false,randColor);
          if(fr1[j*6+i]==1)
          {bmpData.copyPixels(singlePixel,pixelRect,copyPoint);}
         }
        }
        x=200;y=200;
    }
   
    // CACHE
    public function cacheFrame(binaryArray:Array):void
    {
        bmpData=new BitmapData(pixelWidth*4,pixelHeight*4,true,0x000000);
        for(i=0;i<6;i++)
        {
         for(j=0;j<6;j++)
         {
          copyPoint.x=i*4;copyPoint.y=j*4;
          var randColor:uint = Math.random() * 0xFFFFFF; singlePixel=new BitmapData(pixelWidth*4,pixelHeight*4,false,randColor);
          if(binaryArray[j*6+i]==1)
          {bmpData.copyPixels(singlePixel,pixelRect,copyPoint);}
         }
        }
        bmpDataStrip.push(bmpData);
    }
}

import flash.display.*;
import flash.geom.*;

class Particle
{
    public const pixelWidth:int=3;
    public const pixelHeight:int=3;
    public const sizeOfPixels:int=2;

    public var singlePixel:BitmapData;
    public var bmpData:BitmapData;
    public var copyPoint:Point=new Point(0,0);
    public var particleRect:Rectangle=new Rectangle(0,0,pixelWidth,pixelHeight);
    public var pixelRect:Rectangle=new Rectangle(0,0,sizeOfPixels,sizeOfPixels);

    public var x:Number=0.0;
    public var y:Number=0.0;
    public var xv:Number=0.0;
    public var yv:Number=0.0;

    public var i:int=0;
    public var j:int=0;

    // Letter definitions
    public var a:Array=[1,1,1,
                        1,0,1,
                        1,1,1];

    // CONSTRUCTOR
    public function Particle()
    {
        singlePixel=new BitmapData(2,2,false,0xCCDDEE);
        bmpData=new BitmapData(pixelWidth*sizeOfPixels,pixelHeight*sizeOfPixels,true,0x000000);
        copyPoint.x=2;
        copyPoint.y=2;
        x=-200;y=-200;

        for(i=0;i<pixelWidth;i++)
        {
         for(j=0;j<pixelHeight;j++)
         {
          copyPoint.x=i*sizeOfPixels;copyPoint.y=j*sizeOfPixels;
          if(a[j*pixelWidth+i]==1)
          {bmpData.copyPixels(singlePixel,pixelRect,copyPoint);}
         }
        }
    }
}

import flash.display.*;
import flash.geom.*;

class Text
{
    public const TOTAL_TXT_CHARS:int=26+1+10;
    public var txtArray:Array;
    public var iCount:int=0;
    public var jCount:int=0;
    public var kCount:int=0;
    public var widths:Array=
                            [
                             // upper case
                             7,7,7,7,7,7,7,7,3,6,7,6,7,7,7,7,7,7,7,7,7,7,9,7,7,7,
                             // space
                             7,
                             // digits
                             7,3,7,7,7,7,7,7,7,7                             
                             ];
                             
    public var totalLetters:int;
 
    // CONSTRUCTOR
    public function Text()
    {

        // Array initialisation
        //txtArray=new Array(27+10);
        txtArray=new Array(TOTAL_TXT_CHARS);
        for(iCount=0;iCount<txtArray.length;iCount++) { txtArray[iCount]=new Array(8); }
        for(iCount=0;iCount<txtArray.length;iCount++) 
        { 
         for(jCount=0;jCount<txtArray[iCount].length;jCount++)
         {
          txtArray[iCount][jCount]=new Array(8);
         }
        }        

        // Letter definitions
         var a:Array=[0,0,0,0,0,0,0,0,
                      0,0,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,1,1,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var b:Array=[0,0,0,0,0,0,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,1,1,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var c:Array=[0,0,0,0,0,0,0,0,
                      0,0,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,1,1,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var d:Array=[0,0,0,0,0,0,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,1,1,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var e:Array=[0,0,0,0,0,0,0,0,
                      0,1,1,1,1,1,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,1,1,1,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var f:Array=[0,0,0,0,0,0,0,0,
                      0,0,1,1,1,1,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var g:Array=[0,0,0,0,0,0,0,0,
                      0,0,1,1,1,1,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,1,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,1,1,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var h:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,1,1,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var i:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var j:Array=[0,0,0,0,0,0,0,0,
                      0,0,0,0,1,0,0,0,
                      0,0,0,0,1,0,0,0,
                      0,0,0,0,1,0,0,0,
                      0,1,0,0,1,0,0,0,
                      0,0,1,1,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var k:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,1,0,0,0,
                      0,1,1,1,0,0,0,0,
                      0,1,0,0,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var l:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,1,1,1,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var m:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,0,1,1,0,0,
                      0,1,0,1,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var n:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,0,0,1,0,0,
                      0,1,0,1,0,1,0,0,
                      0,1,0,0,1,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var o:Array=[0,0,0,0,0,0,0,0,
                      0,0,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,1,1,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var p:Array=[0,0,0,0,0,0,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var q:Array=[0,0,0,0,0,0,0,0,
                      0,0,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,1,1,0,0,0,
                      0,0,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0];

         var r:Array=[0,0,0,0,0,0,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,1,1,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var s:Array=[0,0,0,0,0,0,0,0,
                      0,0,1,1,1,1,0,0,
                      0,1,0,0,0,0,0,0,
                      0,0,1,1,1,0,0,0,
                      0,0,0,0,0,1,0,0,
                      0,1,1,1,1,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var t:Array=[0,0,0,0,0,0,0,0,
                      0,1,1,1,1,1,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var u:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,1,1,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var v:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,0,1,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var w:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,1,0,0,1,
                      0,1,0,0,1,0,0,1,
                      0,1,0,0,1,0,0,1,
                      0,1,0,0,1,0,0,1,
                      0,0,1,1,0,1,1,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var x:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,0,1,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,1,0,1,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var y:Array=[0,0,0,0,0,0,0,0,
                      0,1,0,0,0,1,0,0,
                      0,0,1,0,1,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];

         var z:Array=[0,0,0,0,0,0,0,0,
                      0,1,1,1,1,1,0,0,
                      0,0,0,0,1,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,1,0,0,0,0,0,
                      0,1,1,1,1,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0];
                      
          var space:Array=[0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                      
          var num0:Array= [0,0,0,0,0,0,0,0,
                           0,0,1,1,1,0,0,0,
                           0,1,0,0,0,1,0,0,
                           0,1,0,0,0,1,0,0,
                           0,1,0,0,0,1,0,0,
                           0,0,1,1,1,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                      
          var num1:Array= [0,0,0,0,0,0,0,0,
                           0,1,0,0,0,0,0,0,
                           0,1,0,0,0,0,0,0,
                           0,1,0,0,0,0,0,0,
                           0,1,0,0,0,0,0,0,
                           0,1,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num2:Array= [0,0,0,0,0,0,0,0,
                           0,1,1,1,1,1,0,0,
                           0,0,0,0,0,1,0,0,
                           0,1,1,1,1,1,0,0,
                           0,1,0,0,0,0,0,0,
                           0,1,1,1,1,1,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num3:Array= [0,0,0,0,0,0,0,0,
                           0,1,1,1,1,0,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,1,1,1,0,0,0,
                           0,0,0,0,0,1,0,0,
                           0,1,1,1,1,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num4:Array= [0,0,0,0,0,0,0,0,
                           0,1,0,0,0,1,0,0,
                           0,1,0,0,0,1,0,0,
                           0,0,1,1,1,0,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num5:Array= [0,0,0,0,0,0,0,0,
                           0,0,1,1,1,1,0,0,
                           0,1,0,0,0,0,0,0,
                           0,0,1,1,1,0,0,0,
                           0,0,0,0,0,1,0,0,
                           0,1,1,1,1,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num6:Array= [0,0,0,0,0,0,0,0,
                           0,0,1,1,1,1,0,0,
                           0,1,0,0,0,0,0,0,
                           0,0,1,1,1,0,0,0,
                           0,1,0,0,0,1,0,0,
                           0,0,1,1,1,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num7:Array= [0,0,0,0,0,0,0,0,
                           0,1,1,1,1,0,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num8:Array= [0,0,0,0,0,0,0,0,
                           0,0,1,1,1,0,0,0,
                           0,1,0,0,0,1,0,0,
                           0,0,1,1,1,0,0,0,
                           0,1,0,0,0,1,0,0,
                           0,0,1,1,1,0,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];
                           
          var num9:Array= [0,0,0,0,0,0,0,0,
                           0,0,1,1,1,0,0,0,
                           0,1,0,0,0,1,0,0,
                           0,0,1,1,1,0,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,1,0,0,
                           0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0];

        var allLetters:Array=
        [
         a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,
         space,
         num0,num1,num2,num3,num4,num5,num6,num7,num8,num9
        ];

        totalLetters=TOTAL_TXT_CHARS;

        // Array alphabet population             
        for(iCount=0;iCount<totalLetters;iCount++)
        {
         for(jCount=0;jCount<8;jCount++)
         {
          for (kCount=0;kCount<8;kCount++)
          {
           var letter:Array=allLetters[iCount];
           txtArray[iCount][jCount][kCount]=letter[kCount*8+jCount];
          }
         }
        }         
    }
}


