/**
 * Copyright Sammi ( http://wonderfl.net/user/Sammi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nyNl
 */

// forked from Sammi's forked from: flash on 2010-2-25
// forked from yd_niku's flash on 2010-2-25
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    public class FlashTest extends Sprite {
            private var _canvas:Shape;
            private var _texture:BitmapData;
            private var _points:Vector.<Vertex> = new Vector.<Vertex>();
            private var _vertices:Vector.<Number> = new Vector.<Number>();
            
            private var _indices:Vector.<int> = new Vector.<int>();
        private var _uvData:Vector.<Number> = new Vector.<Number>();
                    
            public function FlashTest() {
                _canvas = new Shape();
                addChild(_canvas);
            
                var stepX:uint = 5;
                var stepY:uint = 5;
                var lenX:uint = 465/stepX >>0;
                var lenY:uint = 465/stepY >>0;
                var edgeW:uint = stepX-1;
                var edgeH:uint = stepY-1;
                
            var p:Point;
            for( var py:int=0; py<stepY; ++py ) {
                for( var px:int=0; px<stepX; ++px ) {
                    p = new Vertex( px*lenX, py*lenY );
                    _points.push( p)
                    _vertices.push( p.x, p.y );
                    _uvData.push( px/edgeW, py/edgeH );
                }
            }
            
            var uvW:Number = 1/edgeW;
            var uvH:Number = 1/edgeH;
            
            for( var h:int=0; h<edgeH; ++h ) {
                for( var w:int=0; w<edgeW; ++w ) {
                    var num:int = h*edgeH + w;
                    
                    var a:int = num + h;
                    var b:int = a+1;
                    var c:int = a+stepX;
                    var d:int = a+stepX+1;
                    
                    _indices.push( a, b, d,  a, c, d );
                }
            }
                addEventListener(Event.ENTER_FRAME,enterframeHandler);
                
                var url:String = "http://assets.wonderfl.net/images/related_images/0/0e/0e8c/0e8cb3fa40a65539d2adf599ab55a156a587e012";
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE,loadCompleteHandler);
            loader.load(new URLRequest(url), new LoaderContext(true));
        }
        private function loadCompleteHandler(e:Event):void{
            var content:Bitmap = LoaderInfo(e.target).content as Bitmap;
            addChildAt(content,0);
            _texture = content.bitmapData;
        }
        private function enterframeHandler(e:Event):void{
            calcuration();
                render();
        }
        public function calcuration():void{
            var diffX:Number, diffY:Number;
            var distance:Number;
            var strength:Number
            for each( var p:Vertex in _points ) {
                diffX = mouseX - p.x;
                diffY = mouseY - p.y;
                distance = Math.sqrt(diffX*diffX + diffY*diffY);
                strength = distance/(465);
                p.x += diffX *0.1;
                p.y += diffY *0.1;
                
                
                p.x += (p.defX - p.x) *strength;
                p.y += (p.defY - p.y) *strength;
            }
        }
        
        public function render():void{
            _canvas.graphics.clear();
            var p:Vertex;
            if(_texture) {
                for( var i :int =0; i<_points.length; ++i ) {
                    p = _points[i];
                    _vertices[ i*2 ] = p.x;
                    _vertices[ i*2 +1 ] = p.y;
                }
            
                    
                    _canvas.graphics.beginBitmapFill(_texture);
                _canvas.graphics.drawTriangles( _vertices, _indices, _uvData );
                   _canvas.graphics.endFill();
            }
            for each( p in _points ) {
                    _canvas.graphics.beginFill(0xFF0000);
                    _canvas.graphics.drawRect(p.x,p.y,2,2);
                    _canvas.graphics..endFill();
            }
        }
    }
}

import flash.geom.*;
class Vertex extends Point{
    public var defX:Number;
    public var defY:Number;
    public function Vertex(x:Number,y:Number){
        super(x,y);
        defX = x;
        defY = y;
    }
}


    
