/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nxrL
 */

package{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import com.bit101.components.Window;
	import com.bit101.components.RadioButton;

	public class Main extends Sprite{
		private var color:Array = [0xFEBF05,0xFFD65D];
		private var start:Point = new Point();
		private var canvas:Sprite = new Sprite();
		private var drag:Sprite = new Sprite();
		
		public function Main(){
			Wonderfl.capture_delay(15);
			canvas.graphics.beginFill(0xFFFFFF);
			canvas.graphics.drawRect(0,0,465,465);
			canvas.graphics.endFill();
			addChild(canvas);
			
			drag = new Sprite();
			addChild(drag);

			var window:Window = new Window(this,362,362,"Color");
			var button1:RadioButton = new RadioButton(window.content,5,5,"Yellow",true, function():void{color = [0xFEBF05,0xFFD65D]});
			var button2:RadioButton = new RadioButton(window.content,5,20,"Blue",false, function():void{color = [0x80E0F8,0xCDF8FF]});
			var button3:RadioButton = new RadioButton(window.content,5,35,"Red",false,  function():void{color = [0x6D0019,0xA80329]});
			var button4:RadioButton = new RadioButton(window.content,5,50,"Green",false,function():void{color = [0x7DE31F,0xC7FE30]});
			var button5:RadioButton = new RadioButton(window.content,5,65,"Pear",false, function():void{color = [0xD1D360,0xE5E695]});

			stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
		}

		private function onMouseDown(event:MouseEvent):void{
			stage.x = mouseX;
			stage.y = mouseY;

			drag.graphics.clear();
			drag.graphics.lineStyle(1.0,0x7F7F7F);
			drag.graphics.beginFill(0xFFFFFF);
			drag.graphics.drawCircle(start.x,start.y,3);
			drag.graphics.endFill();

			stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);

		}
		
		private function onMouseMove(event:MouseEvent):void{
			drag.graphics.clear();

			drag.graphics.lineStyle(1.0,0x9F9F9F);
			drag.graphics.moveTo(start.x,start.y);
			drag.graphics.lineTo(mouseX,mouseY);
			
			drag.graphics.lineStyle(1.0,0x7F7F7F);
			drag.graphics.beginFill(0xFFFFFF);
			drag.graphics.drawCircle(start.x,start.y,3);
			drag.graphics.drawCircle(mouseX,mouseY,3);
			drag.graphics.endFill();
		}

		private function onMouseUp(event:MouseEvent):void{
			drag.graphics.clear();
			stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
			
			var dist:Number = Math.sqrt(Math.pow(mouseX - start.x,2) + Math.pow(mouseY - start.y,2));
			var radian:Number = Math.atan2(mouseY - start.y,mouseX - start.x);
			
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(1400,1400,0,-700,-700);
			canvas.graphics.clear();
			canvas.graphics.beginGradientFill("linear",color,[1.0,1.0],[127,128 + dist / 1400 * 255],matrix);
			canvas.graphics.drawRect(-700,-700,1400,1400);
			canvas.graphics.endFill();
			canvas.x = start.x;
			canvas.y = start.y;
			canvas.rotation = radian / (Math.PI / 180);
		}
	}

}
