/**
 * Copyright Karl94 ( http://wonderfl.net/user/Karl94 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nxd7
 */

// forked from paul600smith's forked from: Pixel Bender Displacement Map Fakes 3D Effect
// forked from jozefchutka's Pixel Bender Displacement Map Fakes 3D Effect
package{
    // read more and download pbk file here:
    // http://blog.yoz.sk/2010/05/pixel-bender-displacement-map-fakes-3d-effect
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.ByteArray;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class PBDisplacement extends Sprite{
        private var sourcePath:String = "http://blog.yoz.sk/examples/pixelBenderDisplacement/";
        private var index:int = -1;
        private var sources:Array = [
            {image:"mountain.jpg", map:"mountainMap.jpg"},
            {image:"flower.jpg", map:"flowerMap.jpg"},
            {image:"jump.jpg", map:"jumpMap.jpg"},
            {image:"building.jpg", map:"buildingMap.jpg"},
            {image:"bird.jpg", map:"birdMap.jpg"},
            {image:"greece.jpg", map:"greeceMap.jpg"},
            {image:"face.jpg", map:"faceMap.jpg"},
            {image:"prague.jpg", map:"pragueMap.jpg"},
            {image:"graphics.jpg", map:"graphicsMap.jpg"}
        ]
        
        private var filterLeft:DisplacementMapFilter = new DisplacementMapFilter();
        private var filterRight:DisplacementMapFilter = new DisplacementMapFilter();
        
        private var mapLoader:Loader = new Loader();
        
        private var imageLoader:Loader = new Loader();
        private var imageLeft:Bitmap = new Bitmap();
        private var imageRight:Bitmap = new Bitmap();
        
        public function PBDisplacement():void{
            addChild(imageLoader);
            addChild(imageLeft);
            addChild(imageRight);
            addChild(mapLoader);
            
            filterLeft.componentX = filterRight.componentX = BitmapDataChannel.RED;
            filterLeft.componentY = filterRight.componentY = BitmapDataChannel.RED;
            filterLeft.mode = filterRight.mode = DisplacementMapFilterMode.CLAMP;
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
            stage.addEventListener(MouseEvent.CLICK, changeSource);
            changeSource();
        }
        
        private function changeSource(e:Event = null):void{
            index = index+1 >= sources.length ? 0 : index+1;
            var source:Object = sources[index];
            
            var type:String = Event.COMPLETE;
            var context:LoaderContext = new LoaderContext(true);
            
            if(imageLoader){
                imageLoader.unload();
            }
            
            var imageRequest:URLRequest = new URLRequest(sourcePath+source.image);
            imageLoader.load(imageRequest, context);
            imageLoader.contentLoaderInfo.addEventListener(type, imageComplete);
            
            if(mapLoader){
                mapLoader.unload();
            }
            
            var mapRequest:URLRequest = new URLRequest(sourcePath+source.map);
            mapLoader.load(mapRequest, context);
            mapLoader.contentLoaderInfo.addEventListener(type, mapComplete);
        }
        
        private function imageComplete(event:Event):void{
            var image:BitmapData = Bitmap(imageLoader.content).bitmapData;
            imageLoader.width = 100;
            imageLoader.height = image.height*imageLoader.width/image.width;
            
            imageLeft.bitmapData = imageRight.bitmapData = image;
            imageLeft.width = imageRight.width = stage.stageWidth/2;
            imageRight.x = imageLeft.width;
            
            imageLeft.height = imageRight.height = image.height*imageLeft.width/image.width;
            imageLeft.y = imageRight.y = (stage.stageHeight-imageLeft.height)/2;
            
            complete();
        }
        
        private function mapComplete(event:Event):void{
            var image:BitmapData = Bitmap(mapLoader.content).bitmapData;
            mapLoader.width = 100;
            mapLoader.height = image.height*mapLoader.width/image.width;
            mapLoader.x = stage.stageWidth-mapLoader.width;
            
            complete();
        }
        
        private function complete():void{
            if(!imageLoader.content || !mapLoader.content){
                return;
            }
            var image:BitmapData = Bitmap(mapLoader.content).bitmapData;
            (filterLeft.mapBitmap = filterRight.mapBitmap = new BitmapData(imageLeft.width, imageLeft.height, false)).draw(image, new Matrix(imageLeft.width/image.width, 0, 0, imageLeft.height/image.height), new ColorTransform(0.5, 0.5, 0.5, 1, 128, 128, 128));
        }
        
        private function enterFrame(event:Event):void{
            if(!imageLoader.content || !mapLoader.content){
                return;
            }
            
            var dx:Number = (stage.stageWidth/2-mouseX);
            var dy:Number = (stage.stageHeight/2-mouseY);
            
            /*imageContainer.rotationX -= (imageContainer.rotationX + dy / 15) / 10;
            imageContainer.rotationY -= (imageContainer.rotationY - dx / 15) / 10;
             
            filter.scaleX = imageContainer.rotationY;
            filter.scaleY = -imageContainer.rotationX;*/
            
            filterLeft.scaleX = (filterRight.scaleX = dx/10-20)+40;//((filterRight.scaleX+1)-dx/15)/10-1)+2;
            filterLeft.scaleY = filterRight.scaleY -= (filterRight.scaleY-dy/15)/10;
            imageLeft.filters = [filterLeft];
            imageRight.filters = [filterRight];
        }
    }
}