/**
 * Copyright PAPER104 ( http://wonderfl.net/user/PAPER104 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nwdg
 */

// forked from okoi's SpiralLine
package 
{
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    
    import frocessing.color.ColorHSV;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        public var canvas:Sprite;
        public var bitmapdata:BitmapData;
        
        public var startAngle:Number = 0;
        public var points:/*StartingPoint*/Array = [];
        public static const POINTSNUM:int = 10;
        
        public var rotspeed:Number = 0;
        
        public var color:ColorHSV = new ColorHSV();
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            bitmapdata = new BitmapData( WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap(bitmapdata) );
            
            canvas = new Sprite();
            addChild( canvas );
            
            
            for ( var i:int = 0; i < POINTSNUM; i++ )
            {
                var point:StartingPoint = new StartingPoint();
                point.angle = i * (360/POINTSNUM);
                points.push( point );
            }
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {
            
            var g:Graphics = canvas.graphics;
            
            var rad:Number = startAngle * Math.PI / 180;
            var mainsin:Number = Math.sin( rad );
            var maincos:Number = Math.cos( rad );
            var sx:Number = maincos * 250 + WIDTH / 2;
            var sy:Number = mainsin * 250 + HEIGHT / 2;
            g.clear();
            g.lineStyle(1, 0xFFFFFF);
            
            for ( var i:int = 0; i < POINTSNUM; i++ )
            {
                color.h = points[i].angle;
                
                
                for ( var j:int = 0; j <= 100; j++ )
                {
                    var defx:Number = maincos * (250 - (5 * j)) + WIDTH / 2;
                    var defy:Number = mainsin * (250 - (5 * j)) + HEIGHT / 2;
                    var angle:Number = (points[i].angle + (j * rotspeed)) % 360;
                    rad = angle * Math.PI / 180;
                    var sin:Number = Math.sin( rad );
                    var cos:Number = Math.cos( rad );
                    
                    var psx:Number = cos * 40;
                    var psy:Number = sin * 80;
                    
                    var x:Number = psx * maincos + psy * -mainsin + defx;
                    var y:Number = psx * mainsin + psy * maincos + defy;
                    
                    var alpha:Number = (cos + 1) / 2 + 0.5;
                    
                    g.lineStyle(1, color.value, alpha);
                //    g.drawCircle( x, y, 3 );
                    if ( j == 0 )    g.moveTo( x, y );
                    else             g.lineTo( x, y );
                }
                
                points[i].angle = (points[i].angle + 1) % 360;
            }
            
            bitmapdata.lock();
            bitmapdata.draw( canvas );
            bitmapdata.applyFilter( bitmapdata, bitmapdata.rect, new Point(), new BlurFilter() );
            bitmapdata.unlock();
            
            
            
            rotspeed = rotspeed + 0.05;
            rotspeed %= 360;
            
            startAngle = (startAngle + 0.1) % 360;
        }
        
        
        
    }
    
}

class StartingPoint {
    public var angle:Number;
    public var x:Number;
    public var y:Number;
}