/**
 * Copyright Seiya.Kai ( http://wonderfl.net/user/Seiya.Kai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nw5F
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="600",height="600",frameRate="60")]
    public class Main extends Sprite
    {
        private var stageWidth:Number = 600;
        private var stageHeight:Number = 600;
        
        private var odango:Odango;
        private var akarin:Akarin;
        
        private var clickCheck:int = 0;
        
        public function Main()
        {
            setOdango();
        }
        
        public function setOdango():void
        {
            odango  = new Odango();
            stage.addChild(odango);
            odango.x = stageWidth/2;
            odango.y = stageHeight/2;
            odango.addEventListener(MouseEvent.CLICK,onClick);
        }
        
        private function onClick(e:MouseEvent):void
        {
            if(clickCheck == 0)
            {
                akarin = new Akarin();
                stage.addChild(akarin);
                akarin.x = stageWidth/2;
                akarin.y = 100;
                odango.alpha = 0.5;
                odango.addEventListener(Event.ENTER_FRAME,onEnterFrame);
                clickCheck = 1;
            }
        }
        
        private function onEnterFrame(e:Event):void
        {
            odango.scaleX -= 0.005;
            odango.scaleY -= 0.005;
            odango.rotation += 6;
            
            if(odango.scaleX < 0.1){
                stage.removeChild(odango);
                odango.removeEventListener(Event.ENTER_FRAME,onEnterFrame);
                stage.removeChild(akarin);
                setOdango();
                clickCheck = 0;
            }
        }
    }
}


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class Odango extends Sprite
{    
    private var s1:Sprite = new Sprite();
    private var s2:Sprite = new Sprite();
    
    private var lineColor:uint = 0xAA494D;
    private var fillColor:uint = 0xE3767C;
    private var lineAlpha:Number = 1.0;
    private var fillAlpha:Number = 1.0;
    
    private var bitmap:BitmapData;
    private var image:Bitmap;
    
    public function Odango()
    {
        var b:int = 130;
        
        // Odango
        s1.graphics.beginFill(fillColor,fillAlpha);
        s1.graphics.lineStyle(5,lineColor,lineAlpha);
        s1.graphics.drawCircle(0+b,0+b,100);
        s1.graphics.endFill();
        
        s1.graphics.lineStyle(3,lineColor,lineAlpha);
        s1.graphics.moveTo(-65+b,75+b);
        s1.graphics.curveTo(0+b,95+b,65+b,75+b);
        
        s1.graphics.moveTo(-97+b,20+b);
        s1.graphics.curveTo(40+b,40+b,40+b,-90+b);
        
        s1.graphics.moveTo(-68+b,-70+b);
        s1.graphics.curveTo(20+b,-60+b,23+b,-20+b);
        
        s1.graphics.moveTo(-20+b,-60+b);
        s1.graphics.curveTo(-50+b,-10+b,-30+b,18+b);
        
        // Odango no shita
        s2.graphics.beginFill(fillColor,fillAlpha);
        s2.graphics.lineStyle(5,lineColor,lineAlpha);
        s2.graphics.moveTo(-20+b,0+b);
        s2.graphics.lineTo(-120+b,250+b);
        s2.graphics.curveTo(0+b, 300+b, 120+b, 250+b);
        s2.graphics.lineTo(20+b,0+b);
        s2.graphics.lineTo(-20+b,0+b);
        s2.graphics.endFill();
        
        s2.graphics.lineStyle(3,lineColor,lineAlpha);
        s2.graphics.moveTo(0+b,0+b);
        s2.graphics.lineTo(15+b,230+b);
        
        // addChild
        var w:Number = ((s1.width > s2.width) ? s1.width : s2.width) + b;
        var h:Number = ((s1.height > s2.height) ? s1.height : s2.height) +b;
        
        bitmap = new BitmapData(w,h,true,0xFFFFFF);
        image = new Bitmap(bitmap);
        bitmap.draw(s2);
        bitmap.draw(s1);
        addChild(image);
        image.x = -b;
        image.y = -b;
    }
}

class Akarin extends Sprite
{
    private var w:Number = 500;
    private var h:Number = 50;
    private var tf:TextField = new TextField();
    private var s:Sprite = new Sprite();
    private var bitmap:BitmapData;
    private var image:Bitmap;
    
    public function Akarin()
    {
        tf.defaultTextFormat = new TextFormat("_typeWriter", 50, 0xFF0000 );
        tf.text = "アッカリーン";
        tf.autoSize = TextFieldAutoSize.LEFT;
        tf.selectable = false;
        
        bitmap = new BitmapData(tf.textWidth,tf.textHeight,true,0xFFFFFF);
        image = new Bitmap(bitmap);
        bitmap.draw(tf);
        addChild(image);
        
        image.x = -(tf.textWidth/2);
        image.y = -(tf.textHeight/2);
    }
}