/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nw2f
 */

package {
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	[SWF(width = "240",height = "180")]
	public class CalculatingRotation extends Sprite {
		static private const MAX_NUMBER:uint = 1000000;
		static private const SIZE:Number = 1000;
		static private const THETA:Number = 0.1;
		private var coordinates:Vector.<Number> = new Vector.<Number>(uint(MAX_NUMBER * 2));
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		private var my_fmt:TextFormat = new TextFormat();
		public function CalculatingRotation() {
			// Creating a TextField for display
			createTextField();
			initialize();
			// Starting Test
			test_polar();
			test_transform()
		}
		private function initialize():void {
			var half:Number = SIZE / 2;
			for (var i:uint = 0; i < MAX_NUMBER; i++) {
				coordinates[uint(i * 2)] = SIZE * Math.random() - half;
				coordinates[uint(i * 2 + 1)] = SIZE * Math.random() - half;
			}
		}
		private function test_polar():void {
			var started:int = getTimer();
			for (var i:int = 0; i < MAX_NUMBER; i++) {
				var nX:Number = coordinates[uint(i * 2)];
				var nY:Number = coordinates[uint(i * 2 + 1)];
				var radius:Number = Math.sqrt(nX * nX + nY * nY);
				var radians:Number = Math.atan2(nY, nX);
				var nTheta:Number = radians + THETA;
				var newX:Number = radius * Math.cos(nTheta);
				var newY:Number = radius * Math.sin(nTheta);
			}
			xTrace("polar", getTimer() - started);
		}
		private function test_transform():void {
			var started:int = getTimer();
			var nSin:Number = Math.sin(THETA);
			var nCos:Number = Math.cos(THETA);
			for (var i:int = 0; i < MAX_NUMBER; i++) {
				var nX:Number = coordinates[uint(i * 2)];
				var nY:Number = coordinates[uint(i * 2 + 1)];
				var newX:Number = nCos * nX - nSin * nY;
				var newY:Number = nSin * nX + nCos * nY;
			}
			xTrace("transform", getTimer() - started);
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_fmt.align = TextFormatAlign.RIGHT;
			my_txt.defaultTextFormat = my_fmt;
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
		}
		private function xTrace(_str:String,n:int):void {
			my_txt.appendText(String(n) + "\n");
			label_txt.appendText(_str + ":" + "\n");
		}
	}
}