/**
 * Copyright geta ( http://wonderfl.net/user/geta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nvrl
 */

// forked from webgyo's forked from: [Stardust] マウスに追随するパーティクル
// forked from clockmaker's [Stardust] マウスに追随するパーティクル
package {
	import flash.display.*;
	import flash.events.*;
	
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.common.emitters.Emitter;
	import idv.cjcat.stardust.common.renderers.Renderer;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;

	[SWF(width=465, height=465, frameRate=48, backgroundColor=0)]
	public class Main extends Sprite {
		protected var emitter:Emitter; // エミッター
		protected var renderer:Renderer; // レンダラー

		// コンストラクタ
		public function Main() {
			
			// パーティクルシステムの構築
			emitter = new MyEmitter(new SteadyClock(1)); // エミッターに1フレームに発生させたい数値を指定
			renderer = new DisplayObjectRenderer(this);
			renderer.addEmitter(emitter);
			
			// エンターフレームイベントの登録
			addEventListener(Event.ENTER_FRAME, loop);
			
			// bg
			graphics.beginFill(0); graphics.drawRect(0,0,465,465);
		}

		// エンターフレームイベント
		private function loop(e:Event):void {
			// パーティクルの発生位置をマウス座標にする
			MyEmitter(emitter).point.x += (mouseX - MyEmitter(emitter).point.x) * 0.1;
			MyEmitter(emitter).point.y += (mouseY - MyEmitter(emitter).point.y) * 0.1;
			// エミッター更新
			emitter.step();
		}
	}
}

import idv.cjcat.stardust.common.actions.*;
import idv.cjcat.stardust.common.clocks.*;
import idv.cjcat.stardust.common.initializers.*;
import idv.cjcat.stardust.common.math.*;
import idv.cjcat.stardust.twoD.actions.*;
import idv.cjcat.stardust.twoD.emitters.*;
import idv.cjcat.stardust.twoD.initializers.*;
import idv.cjcat.stardust.twoD.zones.*;
/**
 * 2Dのエミッター
 * @author yasu
 */
class MyEmitter extends Emitter2D {

	public var point:SinglePoint = new SinglePoint();; // パーティクルの発生位置

	public function MyEmitter(clock:Clock = null) {
		super(clock);
		
		// ------------------------------
		// パーティクルの属性を定義
		// ------------------------------
		addInitializer(new DisplayObjectClass(Dust));　// アイテムを指定
		addInitializer(new Position(point));　// 発生位置
		addInitializer(new Velocity(new LazySectorZone(0.00001, 0)));　// 移動距離
		addInitializer(new Life(new UniformRandom(30, 5)));　// 生存する領域

		// ------------------------------
		// パーティクルのアクションを定義
		// ------------------------------
		addAction(new Age()); // 寿命を有効化
		addAction(new DeathLife()); // 消えるを有効化
		addAction(new Accelerate(0.2)); // 加速を有効化
		addAction(new Move()); // 移動を有効化
		addAction(new ScaleCurve(1, 7)); // スケール変化を有効化
	}
}

/**
 * パーティクルの飛ばすアイテム
 * @author yasu
 */
import flash.display.*;
import frocessing.color.ColorHSV;

class Dust extends Sprite {
	static private var col:int = 180;
	public function Dust() {
		var color:ColorHSV = new ColorHSV(col+=1, 0.7);
		// 円を描く
		graphics.beginFill(color.value, 0.5);
		graphics.drawCircle(16, 16, 16);
		graphics.beginFill(color.value, 1);
		graphics.drawCircle(16, 16, 8);
		// ブレンドモード
		blendMode = BlendMode.ADD;
	}
}