/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nvmw
 */

// forked from rect's forked from: SiON Tenorion
// forked from keim_at_Si's SiON Tenorion
// SiON TENORION
package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.text.TextField;
    import org.si.sion.*;
    import org.si.sion.events.*;
    import org.si.sion.sequencer.SiMMLTrack;
    import org.si.sion.utils.SiONPresetVoice;
     
     
     [SWF(width="465", height="465", backgroundColor="#ffffff", frameRate=30)]
     public class Tenorion extends Sprite {
         // driver
         public var driver:SiONDriver = new SiONDriver();
         
         // preset voice
         //public var presetVoice:SiONPresetVoice = new SiONPresetVoice();
         
         //custom coice
         public var customVoice:CustomVoice = new CustomVoice();
         
         // voices, notes and tracks
         public var tracks:Vector.<SiMMLTrack> = new Vector.<SiMMLTrack>(16);
         public var effsends:Vector.<Number> = Vector.<Number>([ 0, 0.2, 0.3, 0.3,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1]);
         public var voices:Vector.<int> = Vector.<int>([ 0, 1, 2, 3,  4, 4, 4, 4,  4, 4, 4, 4,  4, 4, 4, 4]);
         public var notes:Vector.<int>  = Vector.<int>([36,36,60,60, 43,48,55,60, 65,67,70,72, 77,79,82,84]);

         // beat counter
         public var beatCounter:int;
         
         // control pad
         public var matrixPad:MatrixPad;
         
         // constructor
         function Tenorion() {
             
             driver.setVoice(0, customVoice["rect.kick"]);  // bass drum
             driver.setVoice(1, customVoice["rect.snare"]); // snare drum
             driver.setVoice(2, customVoice["rect.hc"]); // close hihat
             driver.setVoice(3, customVoice["rect.ho"]); // open hihat
             driver.setVoice(4, customVoice["rect.sequence"]);

             // listen click
             driver.setTimerInterruption(1, _onTimerInterruption);
             driver.setBeatCallbackInterval(1);
             driver.addEventListener(SiONTrackEvent.BEAT, _onBeat);
             driver.addEventListener(SiONEvent.STREAM_START, _onStreamStart);

             // control pad
             matrixPad = new MatrixPad(stage);
             matrixPad.x = 72;
             matrixPad.y = 72;
             addChild(matrixPad);

             // start streaming
             driver.play("#EFFECT1{reverb70,40,60,70}");
         }
         
         
         // _onStreamStart (SiONEvent.STREAM_START) is called back first of all after SiONDriver.play().
         private function _onStreamStart(e:SiONEvent) : void
         {
             // create new controlable tracks and set voice
             for (var i:int=0; i<16; i++) {
                 tracks[i] = driver.sequencer.newControlableTrack();
                 tracks[i].setChannelModuleType(6, 0, voices[i]);
                 tracks[i].velocity = 64;
                 tracks[i].channel.setStreamSend(1, effsends[i]);
             }
             beatCounter = 0;
         }
         
         
         // _onBeat (SiONTrackEvent.BEAT) is called back in each beat at the sound timing.
         private function _onBeat(e:SiONTrackEvent) : void 
         {
             matrixPad.beat(e.eventTriggerID & 15);
         }
         
         
         // _onTimerInterruption (SiONDriver.setTimerInterruption) is called back in each beat at the buffering timing.
         private function _onTimerInterruption() : void
         {
             var beatIndex:int = beatCounter & 15;
             for (var i:int=0; i<16; i++) {
                 if (matrixPad.sequences[i] & (1<<beatIndex)) tracks[i].keyOn(notes[i]);
             }
             beatCounter++;
         }
     }
 }

import org.si.sion.SiONVoice;

dynamic class CustomVoice
{
    function CustomVoice()
    {
        _setOPM("rect.sequence","Sequence Sound",6,6, 10,15,14,6,1,40,0,0,1,0,0, 20,10,12,6,6,18,1,1,0,0,0, 24,15,10,12,8,10,0,1,0,0,0, 20,30,20,8,0,0,0,1,3,0,0);
        _setOPM("rect.kick","Bass Drum",5,5, 31,22,10,7,10,12,0,0,0,3,0, 31,15,10,0,10,0,0,0,3,2,0, 31,3,10,0,8,0,0,0,0,1,0, 31,15,9,0,10,10,0,0,0,0,0);
        _setOPM("rect.snare","Snare Drum",4,7,31,2,0,0,5,0,0,15,3,0,0, 31,17,22,10,8,8,0,0,7,0,0,31, 30,0,0,15,3,0,4,0,0,0, 31,14,16,10,1,0,0,2,0,0,0);
        _setOPM("rect.hc","Hihat Close", 0,7, 31,8,10,10,1,38,2,15,0,3,0, 31,8,10,14,1,38,0,11,0,1,0, 31,5,10,14,1,8,1,9,7,1,0, 31,20,10,10,10,5,1,9,3,2,0);
        _setOPM("rect.ho","Hihat Open", 4,7, 20,6,14,7,10,9,0,15,0,7,0, 28,14,14,10,10,10,1,3,3,3,0, 31,12,6,3,3,10,0,15,7,5,0, 24,22,20,7,10,10,0,3,3,1,0);
    }
    
    private function _setOPM(key:String, name:String, ...args) : void
    {
        var voice:SiONVoice = new SiONVoice();
        voice.paramOPM = args;
        voice.name = name;
        this[key] = voice;
    }
}


 import flash.display.*;
 import flash.events.*;
 import flash.geom.*;

 class MatrixPad extends Bitmap {
     public var sequences:Vector.<int> = new Vector.<int>(16);
     private var canvas:Shape = new Shape();
     private var buffer:BitmapData = new BitmapData(320, 320, true, 0);
     private var padOn:BitmapData  = _pad(0x303050, 0x6060a0);
     private var padOff:BitmapData = _pad(0x303050, 0x202040);
     private var pt:Point = new Point();
     private var colt:ColorTransform = new ColorTransform(1,1,1,0.1)
     
     function MatrixPad(stage:Stage) {
         super(new BitmapData(320, 320, false, 0));
         var i:int;
         for (i=0; i<256; i++) {
             pt.x = (i&15)*20;
             pt.y = (i&240)*1.25;
             buffer.copyPixels(padOff, padOff.rect, pt);
             bitmapData.copyPixels(padOff, padOff.rect, pt);
         }
         for (i=0; i<16; i++) sequences[i] = 0;
         addEventListener("enterFrame", _onEnterFrame);
         stage.addEventListener("click",  _onClick);
     }
     
     private function _pad(border:int, face:int) : BitmapData {
         var pix:BitmapData = new BitmapData(20, 20, false, 0);
         canvas.graphics.clear();
         canvas.graphics.lineStyle(1, border);
         canvas.graphics.beginFill(face);
         canvas.graphics.drawRect(1, 1, 17, 17);
         canvas.graphics.endFill();
         pix.draw(canvas);
         return pix;
     }
     
     private function _onEnterFrame(e:Event) : void {
         bitmapData.draw(buffer, null, colt);
     }
     
     private function _onClick(e:Event) : void {
         if (mouseX>=0 && mouseX<320 && mouseY>=0 && mouseY<320) {
             var track:int = 15-int(mouseY*0.05), beat:int = int(mouseX*0.05);
             sequences[track] ^= 1<<beat;
             pt.x = beat*20;
             pt.y = (15-track)*20;
             if (sequences[track] & (1<<beat)) buffer.copyPixels(padOn, padOn.rect, pt);
             else buffer.copyPixels(padOff, padOff.rect, pt);
         }
     }
     
     public function beat(beat16th:int) : void {
         for (pt.x=beat16th*20, pt.y=0; pt.y<320; pt.y+=20) bitmapData.copyPixels(padOn, padOn.rect, pt);
     }
 }




