/**
 * Copyright twistcube ( http://wonderfl.net/user/twistcube )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nvEe
 */

package
{
	import flash.display.* ;
	import flash.events.* ;
	import flash.net.* ;
	import flash.system.* ;
	import flash.ui.Mouse;
	
	[SWF(width="500", height="500", backgroundColor="0x76c725", frameRate="30")]
	public class Hungry extends Sprite
	{
		private static var _yoyo:Yoyo ;
		
		public function Hungry( )
		{
			init( ) ;
		}
		
		public static function get yoyo( ):Yoyo
		{
			return _yoyo ;
		}
		
		private function init( ):void
		{
			stage.scaleMode = StageScaleMode.NO_SCALE ;
			stage.align     = StageAlign.TOP_LEFT ;
			stage.quality   = StageQuality.HIGH ;
			
			Mouse.hide( ) ;
			
			xCreateObject( ) ;
		}
		
		private function xCreateObject( ):void
		{
			var nSize:Number = 21 ;
			var nTimes:uint = 8 ;
			var nMargin:Number = 1 ;
			var nStartPos:Number = ( stage.stageWidth - ( (nSize*2 + nMargin) * nTimes ) ) / 2 ;
			
			_yoyo = new Yoyo( ) ;
			addChild( _yoyo ) ;
			
			for ( var i:uint = 0; i < nTimes; i++ )
			{
				for ( var j:uint = 0; j < nTimes; j++ )
				{
					var obj:CircleManager = new CircleManager( 0, nSize, 2 * Math.PI, 0, 0xcfff5f ) ;
					obj.x = (nSize*2 + nMargin) * i + nStartPos + nSize ;
					obj.y = (nSize*2 + nMargin) * j + nStartPos + nSize ;
					addChild( obj ) ;
				}
			}
		}
	}
}



import flash.display.* ;
import flash.events.* ;
import flash.geom.* ;
import flash.filters.* ;

class Yoyo extends Sprite
{
	private const SPRING:Number = .1 ;
	private const FRICTION:Number = .95 ;
	private var _vect:Point ;
	private var _source:Sprite ;
	
	public function Yoyo( )
	{
		addEventListener( Event.ADDED_TO_STAGE, init ) ;
		addEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
	}

	private function init( event:Event ):void
	{
		removeEventListener( Event.ADDED_TO_STAGE, init ) ;
		
		_source = new Sprite( ) ;
		x = stage.stageWidth / 2 ;
		y = stage.stageHeight / 2 ;
		_source.graphics.beginFill( 0xe3ce29 ) ;
		_source.graphics.drawCircle( 0, 0, 10 ) ;
		_source.graphics.endFill( ) ;
		addChild( _source ) ;
		
		_vect = new Point( 100 * Math.random( ) - 50, 100 * Math.random( ) - 50 ) ;
		
		addEventListener( Event.ENTER_FRAME, onRender ) ;
	}
	
	private function unload( event:Event = null ):void
	{
		removeEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
		removeEventListener( Event.ENTER_FRAME, onRender ) ;
	}
	
	private function onRender( event:Event ):void
	{
		_vect.x += ( stage.mouseX - x ) * SPRING ;
		_vect.y += ( stage.mouseY - y ) * SPRING ;
		_vect.x *= FRICTION ;
		_vect.y *= FRICTION ;
		x += _vect.x ;
		y += _vect.y ;
	}
}



import flash.display.* ;
import flash.events.* ;

class CircleManager extends Sprite
{
	private var _hankei:uint ;
	private var _hutosa:uint ;
	private var _nagasa:Number ;
	private var _rotation:Number ;
	private var _color:Number ;
	
	private var _circle:CircleObj ;
	
	private var _rotationStep:Number ;
	
	private var _sleep:Number ;
	private var _packStep:Number ;
	
	
	public function CircleManager( __hankei:uint = 50, __hutosa:uint = 1, __nagasa:Number = 2 * Math.PI, __rotation:Number = 0, __color:Number = 0xFFFFFF ):void
	{
		_hankei   = __hankei ;
		_hutosa   = __hutosa ; 
		_nagasa   = __nagasa ;
		_rotation = __rotation ;
		_color    = __color ;
		
		addEventListener( Event.ADDED_TO_STAGE, init ) ;
		addEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
	}

	private function init( event:Event ):void
	{
		removeEventListener( Event.ADDED_TO_STAGE, init ) ;
		
		// --
		
		_circle = new CircleObj( _hankei, _hutosa, _nagasa, 0, _color ) ;
		addChild( _circle ) ;
		
		alpha = .7 ;
		
		_rotationStep = .05 + .2 * Math.random( ) ;
		
		_sleep = 1 ;
		_packStep = 2 * Math.PI * Math.random( ) ;
		addEventListener( Event.ENTER_FRAME, onRender ) ;
	}
	
	private function unload( event:Event = null ):void
	{
		removeEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
		removeEventListener( Event.ENTER_FRAME, onRender ) ;
		
		removeChild( _circle ) ;
		_circle = null ;
	}
		
	private function onRender( event:Event ):void
	{
		var nDiffX:Number = Hungry.yoyo.x - x ;
		var nDiffY:Number = Hungry.yoyo.y - y ;
		var nTarget:Number = Math.atan2( nDiffY, nDiffX ) / Math.PI * 180 ;
		var nDiffR:Number = nTarget - rotation ;
		
		while ( nDiffR > 180 )
		{
			nDiffR -= 360 ;
		}
		while ( nDiffR < -180 )
		{
			nDiffR += 360 ;
		}
		rotation += nDiffR * _rotationStep ;
		
		var nDistance:Number = xGetDistance( Hungry.yoyo.x, Hungry.yoyo.y, x, y ) ;
		var nSleep:Number = 0 ;
		if ( nDistance > 150 )
		{
			_sleep += ( 1 - _sleep ) * .4 ;
		}
		else
		{
			nSleep = 1 ;
			_sleep += ( .7 - _sleep ) * .4 ;
		}
		
		var kaihei:Number =  2 * Math.PI * .3 * Math.sin( _packStep ) * 0.5 + 0.5 ;
		_packStep += .3 ;
		
		_circle.xChangeNagasa( 2 * Math.PI * _sleep + kaihei * nSleep ) ;
	}
	
	private function xGetDistance( p1_x:Number, p1_y:Number, p2_x:Number, p2_y:Number ):Number
	{
		var x:Number = Math.pow( ( p1_x - p2_x ), 2 ) ; 
		var y:Number = Math.pow( ( p1_y - p2_y ), 2 ) ;
		return Math.sqrt( x + y ) ;
	}
}



import flash.display.* ;
import flash.events.* ;

class CircleObj extends Sprite
{
	private var _hankei:uint ;
	private var _hutosa:uint ;
	private var _nagasa:Number ;
	private var _rotation:Number ;
	private var _color:Number ;
	
	private var _mask:Sprite ;
	private var _main:Sprite ;
	
	public function CircleObj( __hankei:uint = 50, __hutosa:uint = 1, __nagasa:Number = 2*Math.PI, __rotation:Number = 0, __color:Number = 0 ):void
	{
		_hankei   = __hankei ;
		_hutosa   = __hutosa ; 
		_nagasa   = __nagasa ;
		_rotation = __rotation ;
		_color    = __color ;
		
		addEventListener( Event.ADDED_TO_STAGE, init ) ;
		addEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
	}

	private function init( event:Event ):void
	{
		removeEventListener( Event.ADDED_TO_STAGE, init ) ;
		
		// --
		
		_mask = new Sprite( ) ;
		_main = new Sprite( ) ;
		
		addChild( _main ) ;
		addChild( _mask ) ;
		
		_main.mask = _mask ;
		
		xDrawMask( ) ;
		xDrawCircle( ) ;
		rotation = (2*Math.PI-_nagasa) / Math.PI * 180 / 2 ;
	}
	
	private function unload( event:Event = null ):void
	{
		removeEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
		
		removeChild( _main ) ;
		removeChild( _mask ) ;
		
		_main = null ;
		_mask = null ;
	}
	
	private function xDrawMask( ):void
	{
		var nHankei:Number = ( _hankei + _hutosa ) * 1.41422 ; // http://www.twist-cube.com/wonderfl/ring_sample.png
		var nTheta:Number ;
		var nX:Number ;
		var nY:Number ;
		
		_mask.graphics.clear( ) ;		
		_mask.graphics.beginFill( 0xFFFFFF ) ;
		
		// right bottom
		nTheta = Math.min( _nagasa, Math.PI / 2 ) ;
		nX = nHankei * Math.cos( nTheta ) ;
		nY = nHankei * Math.sin( nTheta ) ;
		_mask.graphics.moveTo( 0, 0 ) ;
		_mask.graphics.lineTo( nHankei, 0 ) ;
		_mask.graphics.lineTo( nX, nY ) ;
		_mask.graphics.lineTo( 0, 0 ) ;
		_main.graphics.endFill( ) ;
		
		// left bottom
		if ( _nagasa > Math.PI / 2 )
		{
			nTheta = Math.min( (_nagasa - Math.PI / 2), Math.PI / 2 ) + Math.PI / 2 ;
			nX = nHankei * Math.cos( nTheta ) ;
			nY = nHankei * Math.sin( nTheta ) ;
			_mask.graphics.moveTo( 0, 0 ) ;
			_mask.graphics.lineTo( 0, nHankei ) ;
			_mask.graphics.lineTo( nX, nY ) ;
			_mask.graphics.lineTo( 0, 0 ) ;
			_main.graphics.endFill( ) ;
		}
		
		// left top
		if ( _nagasa > Math.PI )
		{
			nTheta = Math.min( (_nagasa - Math.PI), Math.PI / 2 ) + Math.PI ;
			nX = nHankei * Math.cos( nTheta ) ;
			nY = nHankei * Math.sin( nTheta ) ;
			_mask.graphics.moveTo( 0, 0 ) ;
			_mask.graphics.lineTo( -nHankei, 0 ) ;
			_mask.graphics.lineTo( nX, nY ) ;
			_mask.graphics.lineTo( 0, 0 ) ;
			_main.graphics.endFill( ) ;
		}
		
		// right top
		if ( _nagasa > Math.PI + Math.PI/2 )
		{
			nTheta = Math.min( (_nagasa - (Math.PI + Math.PI/2)), Math.PI / 2 ) + Math.PI + Math.PI/2 ;
			nX = nHankei * Math.cos( nTheta ) ;
			nY = nHankei * Math.sin( nTheta ) ;
			_mask.graphics.moveTo( 0, 0 ) ;
			_mask.graphics.lineTo( 0, -nHankei ) ;
			_mask.graphics.lineTo( nX, nY ) ;
			_mask.graphics.lineTo( 0, 0 ) ;
			_main.graphics.endFill( ) ;
		}
	}
	
	private function xDrawCircle( ):void
	{
		_main.graphics.clear( ) ;
		_main.graphics.beginFill( _color );
		_main.graphics.drawCircle( 0, 0, _hankei + _hutosa ) ;
		_main.graphics.drawCircle( 0, 0, _hankei ) ;
		_main.graphics.endFill( ) ;
	}
	
	public function xChangeNagasa( __nagasa:Number ):void
	{
		_nagasa = __nagasa ;
		
		xDrawMask( ) ;
		xDrawCircle( ) ;
		rotation = (2*Math.PI-_nagasa) / Math.PI * 180 / 2 ;
	}
}