/**
 * Copyright satrex ( http://wonderfl.net/user/satrex )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nugi
 */

// forked from Murai's #2 Loop forked from: #1 LikeATimeLine WonderflBook Interactive2
// forked from Murai's #1 LikeATimeLine WonderflBook Interactive2
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    
    /*
    @author Takashi Murai(KAYAX)
    */
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    public class WonderflBook extends Sprite{
        
        private var _ball:Sprite;
        private var _timeGauge:Sprite;
        private var _locus:Sprite;
        
        private var _startX:Number = 0;
        private var _endX:Number=stage.stageWidth;
        private var _startY:Number = stage.stageHeight;
        private var _frameCount:uint = 0;
        
        private var _frameCountLimit:uint = 150; // 最終フレームの位置
        private var _animationFrames:Array;
        
        public function WonderflBook(){
            init();
        }
        
        public function init():void{
            _animationFrames = generateAnimationFrames();
            
            _ball = new Sprite();
            _ball.graphics.lineStyle(1, 0x00ffff);
            _ball.graphics.beginFill(0x00ffff, 0.2);
            _ball.graphics.drawCircle(0, 0, 5);
            _ball.graphics.endFill();
            
           _timeGauge = new Sprite();
           _timeGauge.graphics.beginFill(0x00ffff, 0.5);
           _timeGauge.graphics.drawRect(0,0,stage.stageWidth,3);
           _timeGauge.graphics.endFill();
           _timeGauge.x = -1;
           _timeGauge.y = stage.stageHeight - 3;
           
           _locus =  new Sprite();
           _ball.filters= [new GlowFilter(0x00ffff, 1, 16, 16, 2, 2)];
           
           addChild(_locus);
           addChild(_timeGauge);
           addChild(_ball);
           
           stage.addEventListener(MouseEvent.MOUSE_DOWN, startRec);
           stage.addEventListener(MouseEvent.MOUSE_UP, stopRec);
           
           updateLocus();
           start();
        }
        
        private function generateAnimationFrames():Array{
            var tmp:Array = new Array();
            var easeRatio:Number = 0.1;
            var tmpX:Number = _startX;
            var tmpY:Number = _startY;
            for(var i:uint = 0; i < _frameCountLimit; i++){
                tmpX += (_endX - tmpX) * easeRatio;
                tmp.push(new Point(tmpX, tmpY));
            }
            return tmp;            
        }
        
        private function render(e:Event):void{
            if(_frameCount < _frameCountLimit){
                _ball.x = _animationFrames[_frameCount].x;
                _ball.y = _animationFrames[_frameCount].y;
            }
            else{
                _frameCount=0;
            }
            _timeGauge.width = (_frameCount / _frameCountLimit) * stage.stageHeight;
            _frameCount++;
        }
        
        public function start():void{addEventListener(Event.ENTER_FRAME, render);
        };
        
        public function stop():void{
            removeEventListener(Event.ENTER_FRAME, render);
        }
        
        private function recMouse(e:Event):void{
           if(_frameCount < _frameCountLimit){
               _animationFrames[_frameCount].x = mouseX;
               _animationFrames[_frameCount].y = mouseY;
               updateLocus();
           }
        }
        
        private function startRec(e:Event):void{
            addEventListener(Event.ENTER_FRAME, recMouse);
        }

        private function stopRec(e:Event):void{
            removeEventListener(Event.ENTER_FRAME, recMouse);
        }

        
        private function updateLocus():void{
            _locus.graphics.clear();
            _locus.graphics.lineStyle(1, 0x00ffff, 0.2);
            for(var i:uint = 0; i < _frameCount; i++){
                _locus.graphics.drawCircle(_animationFrames[i].x, _animationFrames[i].y, 2);
            }
        }
    }
}