/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nuYg
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    public class PagerSample extends Sprite {
        
        private var _pager:Pager;
        private var _numField:TextField;
        
        public function PagerSample() {
            _pager = new Pager(20);
            
            _numField = new TextField();
            _numField.width = 60;
            _numField.height = 24;
            addChild(_numField);
            
            var btnPrev:Sprite = new PageButton("PREV");
            var btnNext:Sprite = new PageButton("NEXT");
            
            btnPrev.x = 70;
            btnNext.x = 110;
            
            addChild(btnPrev);
            addChild(btnNext);
            
            btnPrev.addEventListener(MouseEvent.CLICK, prevPage);
            btnNext.addEventListener(MouseEvent.CLICK, nextPage);
            
            updatePager();            
        }
        private function nextPage(e:MouseEvent):void {
            _pager.next();
            
            updatePager();
        }
        private function prevPage(e:MouseEvent):void {
            _pager.prev();
            
            updatePager();
        }
        
        private function updatePager():void {
            _numField.text = String(_pager.currentPage + 1) + "/" + _pager.totalPages + " Page";
        }
    }
}

import flash.display.Sprite;
import flash.text.TextField;

class PageButton extends Sprite {
    public function PageButton(label:String) {
        var textField:TextField = new TextField();
        textField.width = 36;
        textField.height = 24;
        textField.text = label;
        addChild(textField);
        mouseChildren = false;
        buttonMode = true;
    }
}

class Pager {
    private var _currentPage:int;
    private var _totalPages:int;
    
    private var _numField:TextField;
    
    public function Pager(totalPages:int) {
        _currentPage = 0;
        _totalPages = totalPages;
    }
    public function next():void {
        _currentPage = Math.min(_totalPages - 1, _currentPage + 1);
    }
    public function prev():void {
        _currentPage = Math.max(0, _currentPage - 1);
    }
    public function get currentPage():int {
        return _currentPage;
    }
    public function get totalPages():int {
        return _totalPages;
    }
}

