/**
 * Copyright ldi1213 ( http://wonderfl.net/user/ldi1213 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nuMr
 */

// forked from romatica's [Away3D] PointLightTest
/**
 * copyright (c) 2012 www.romatica.com
 * @author itoz
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.lights.PointLight;
    import away3d.containers.View3D;
    import away3d.core.base.SubGeometry;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.PlaneGeometry;
    import away3d.primitives.PrimitiveBase;

    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.utils.getTimer;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    /**
     * 
     */
    public class PointLightSample extends View3D
    {
        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _planeMat : ColorMaterial;
        private var _planeGeo : PrimitiveBase;
        private var _plane : Mesh;
        private var _light : PointLight;
        
       //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function PointLightSample()
        {
            
           //addChild(new Bitmap(source)) ;
           
            antiAlias = 0;
            backgroundColor = 0x333333;

            // ----------------------------------
            // ライト
            // ----------------------------------
            _light = new PointLight();
            //_light.showBounds = true;
            _light.color = 0xffffff;
            _light.fallOff =1200;
            _light.radius = 800;
            scene.addChild(_light);

            var lightPicker : StaticLightPicker = new StaticLightPicker([_light]);

            // ----------------------------------
            // プレーン
            // ----------------------------------
            _planeMat = new ColorMaterial(0x567524);
            _planeMat.lightPicker = lightPicker;
            _planeGeo = new PlaneGeometry(2048, 2048, 64, 64);
            _plane = new Mesh(_planeGeo, _planeMat);
            scene.addChild(_plane);

            // ----------------------------------
            // デコボコ作成
            // ----------------------------------
            var subgeos : Vector.<SubGeometry> = _plane.geometry.subGeometries ;
            var  len : int = subgeos.length;
            for (var j : int = 0; j < len; j++) {
                var geo : SubGeometry = subgeos[j] as SubGeometry;
                var vlen : int = geo.vertexData.length;
                for (var k : int = 0; k < vlen; k += 2) {
                    geo.vertexData[k] += Math.random() * 150 - 75;
                }
            }

            camera.y =1000;
            addEventListener(Event.ENTER_FRAME, update);
            addChild(new AwayStats());
            
            
            
        }

        private function update(event : Event) : void
        {
            var t:Number = getTimer();
            _light.x = -Math.sin(t / 500) * 500;
            _light.y = 500 + Math.cos(t / 250) * 250 ;
            _light.z = -Math.cos(t / 500) * 500 ;
            _light.lookAt(new Vector3D(-_light.z * 0.1, -_light.x * 0.1, _light.x * 0.1));
            camera.x = Math.sin(t / 2000) * 1500;
            camera.z = Math.cos(t / 2000) * 1500;
            camera.lookAt(ZERO);

            render();
          //  renderer.queueSnapshot(source);
        }
    }
}
