/**
 * Copyright asahiufo ( http://wonderfl.net/user/asahiufo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nuHK
 */

package
{
	import flash.text.TextField;
	import flash.display.Sprite;
	
	/**
	 * インターフェースを多重継承した場合、
	 * 複数の継承元インターフェースに同名のメソッドを使用できるか実験。
	 * 結果、インスタンスを設定する変数の型によって、コンパイルできるできないが分かれる。
	 * TestならOKで、ISubならエラーである理由が分からない。
	 */
	public class InterfaceMultiExtendsTest extends Sprite
	{
		public function InterfaceMultiExtendsTest()
		{
			// 型がTestである変数を使うと問題無し
			var test1:Test = new Test();
			test1.x = 10;
			
			// 型がISubである変数を使うとコンパイルエラー
			var test2:ISub = new Test();
			test2.x = 999;
		}
	}
}

class Test implements ISub
{
	private var _x:Number = 0;
	
	public function get x():Number { return _x; }
	public function set x(value:Number):void { _x = value; }
	public function get y():Number { return 10; }
}

interface ISub extends ISuperA, ISuperB
{
}

interface ISuperA
{
	function get x():Number;
	function set x(value:Number):void;
}

interface ISuperB
{
	function get x():Number;
	function set x(value:Number):void;
	function get y():Number;
}