/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ntcH
 */

// forked from undo's 止まったらハジケる玉


package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;


    [SWF(width='465', height='465', frameRate='60', backgroundColor='0xffffff')]
    public class FlashTest extends Sprite
    {
        private var array:Array = new Array();
        private var grv:Number = 1;
        private var bounce:Number = 0.5;
        private var limitSpeed:Number = 1;
        private var minRadius:Number = 5;
        private var maxNum:int = 100;
        
        private var bmp:Bitmap;
        private var bmd:BitmapData;
        private var blankbmd:BitmapData;

        public function FlashTest()
        {
            init();
        }

        private function init():void
        {
            // write as3 code here..
            addEventListener(Event.ADDED_TO_STAGE, onAdded);
        }
        private function onAdded(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, onAdded);
            
            this.bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
            this.bmp = new Bitmap(this.bmd);
            addChild(this.bmp);
            this.blankbmd = this.bmd.clone();
            
            makeFirstBall();
            addEventListener(Event.ENTER_FRAME, onEnter);
        }

        private function makeFirstBall():void
        {
            var b:Ball = new Ball(50, Math.random() * 10 - 5, 0);
            b.x = stage.stageWidth / 2;
            b.y = stage.stageHeight / 2;
            array.push(b);
        }

        private function onEnter(evt:Event):void
        {
            this.bmd.lock();
            this.bmd = this.blankbmd.clone();
            
            var l:int = array.length;
            for(var i:int = l - 1; i >= 0; i--)
            {
                var b:Ball = array[i] as Ball;
                var bounced:Boolean = false;
                b.vy += grv;
                b.x += b.vx;
                b.y += b.vy;
                if(b.x + b.r > stage.stageWidth || b.x - b.r < 0)
                {
                    b.x -= b.vx;
                    b.vx *= -bounce;
                    b.vy *= bounce;
                    bounced = true;
                }
                if(b.y + b.r > stage.stageHeight || b.y - b.r < 0)
                {
                    b.y -= b.vy;
                    b.vx *= bounce;
                    b.vy *= -bounce;
                    bounced = true;
                }
                if(bounced && Math.abs(b.vx)+Math.abs(b.vy) < this.limitSpeed)
                {
                    array.splice(i, 1);
                    if(b.r > minRadius)
                    {
                        for(var j:int = 0; j < 4; j++)
                        {
                            var b1:Ball = new Ball(b.r * 0.7, Math.random() * 100 - 50, Math.random() * 100);
                            b1.x = b.x;
                            b1.y = b.y;
                            array.push(b1);
                        }
                    }
                    else if(array.length == 0)
                    {
                        makeFirstBall();
                    }
                    b = null;
                }
                else
                {
                    this.bmd.copyPixels(b.bmd, b.bmd.rect, new Point(b.x-b.r,b.y-b.r),null,null,true);
                }
            }
            this.bmp.bitmapData = this.bmd;
            this.bmd.unlock();
            
        }
    }
}

import flash.display.BitmapData;
import flash.display.Sprite;

class Ball
{
    public var r:Number;
    public var vx:Number;
    public var vy:Number;
    public var x:Number = 0;
    public var y:Number = 0;
    public var bmd:BitmapData;

    public function Ball(rad:Number = 100, vx:Number = 0, vy:Number = 0, color:uint = 0xff0000)
    {
        r = rad;
        bmd = new BitmapData(r*2,r*2,true,0x00000000);
        var s:Sprite = new Sprite();
        s.graphics.beginFill(color);
        s.graphics.drawCircle(r, r, r);
        s.graphics.endFill();
        bmd.draw(s);

        this.vx = vx;
        this.vy = vy;
    }
}



