/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nt6v
 */

// forked from yd_niku's Sound Star 3D
// forked from yd_niku's forked from: soundtest6
// forked from gaina's soundtest6
//こっそりとSoundMixer.computeSpectrumの第二引数を
//stageクリックでかえれるようにしてみた。
//trueとfalseでの動きの違いを確かめる。

package  
{
    //import flash.media.Camera;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.*;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    //import flash.filters.BlurFilter;
    import frocessing.display.F5MovieClip2DBmp;
    import frocessing.color.*;
    [SWF(width=465,height=465,backgroundColor=0x0)]
    public class soundSpectrum extends F5MovieClip2DBmp
    {
        private var _particles:Vector.<Star>;
        private var snd:Sound;
        private var FFTswitch:Boolean = false;
        private var $color:ColorHSV = new ColorHSV();
        //private var fil:Array = [];
        public function setup():void{
            size( 465, 465 );
            //背景の描画
            background( 0 );
            //HSV
            colorMode( HSV, 1 );
                
            stage.addEventListener(MouseEvent.CLICK, FFTswitcher);
            
            Wonderfl.capture_delay( 15 );
            
            _particles = new Vector.<Star>();
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
        }
        
        private var _camera:Camera = new Camera();
        private var _angleY:Number = 0;
        private var _angleC:Number = 0;
        public function draw():void{
            _angleY+=6;
            _angleC++;
          
            $color.hsv(_angleC%540,0.5,0.2+(_angleC%480)/480*0.3)
            beginFill($color.value,0.95); 
            drawRect(0,0,465,465);
            endFill();
            
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, FFTswitch, 0);
            var i:uint, j:uint;
            
            var lev:Number = 0;
            const DEF_CNT:Number = 36;
            var cnt:Number = DEF_CNT;
            var aX:Number  = Math.cos(_angleY/180*Math.PI);
            var aY:Number  = Math.sin(_angleY/180*Math.PI);
            for (i = 0; i < 2; i++)
            {
                for (j = 0; j < 256; j++)
                {
                    var rf:Number = bytes.readFloat();
                    
                    if (cnt-->0) lev += rf;
                    else {
                        if( lev > 1 ) {
                            var r:Number = random(lev,0.2);
                            var p:Star = new Star();
                            p.x = 0;
                            p.y = 0;
                            p.z = 0;
                            p.vx = lev/3+aX*r;
                            p.vy = Math.random()*lev/6+aY*r/2;
                            p.vz = (Math.random()-0.5)*lev;
                            p.mass = lev/5;
                            _particles.push(p);
                        }
                        cnt = DEF_CNT; lev = 0;
                    }
                }
            }

    
            _camera.rotationY -= 1.5;
            _camera.rotationZ -= 0.5;
            
            var rotX:Number = _camera.rotationX*DIGREE_TO_RADIAN;
            var rotY:Number = _camera.rotationY*DIGREE_TO_RADIAN;
            var rotZ:Number = _camera.rotationZ*DIGREE_TO_RADIAN;
            
            for(var k:int=_particles.length-1; k>=0; k-- ){
                var s:Star = _particles[k];
                if(s.life<=0) {
                    _particles.splice(i,1);
                    continue;
                }
                
                s.x += s.vx;
                s.y += s.vy + Math.sin((s.life%360)/180*Math.PI)+0.5;
                s.z += s.vz;
                s.life--;
                
                var ap :Object = applyRotation( s.x,  s.y,rotZ);// ab = xy
                var zp :Object = applyRotation(ap.b,  s.z,rotX);// ab = yz
                var bp :Object = applyRotation(zp.b, ap.a,rotY);// ab = zx
            
                var persepective:Number = _camera.forcus / ( _camera.forcus + bp.a )* _camera.zoom;
            
                var px:Number = bp.b * persepective + 232;
                var py:Number = zp.a * persepective + 232;
            
                if( px < -100 || px > 565 || py < -100 || py > 565 ) continue;

                stroke(0,0,1,(s.life-80)/80);
                //drawCircle( px, py, persepective*5*s.mass*Math.random() );
                
                var offset:Number = random(Math.PI);
                
                noStroke();
                beginFill(0xFFFFFF,(s.life-80)/80);
                var sradius:Number = random(persepective*5.5,0.2)*s.mass, ssradius:Number, partAngle:Number = Math.PI*2/10;
                
                var ssx:Number, ssy:Number;
                for(var t:int=0; t<10;++t){
                    ssradius = (t%2==0?0.35:1)*sradius;
                    ssx = px+Math.sin(partAngle*t+offset)*ssradius;
                    ssy = py+Math.cos(partAngle*t+offset)*ssradius;
                    if(t==0) moveTo( ssx, ssy );
                    lineTo( ssx, ssy ); 
                }
                endFill();
            }
        }
            
        private var speedAngle:Number = 0;
        private var DIGREE_TO_RADIAN:Number = 1/180*Math.PI;
        
        private function applyRotation(a:Number,b:Number,rot:Number):Object {
          return {
            a:( Math.cos(rot)*a - Math.sin(rot)*b ),
            b:( Math.sin(rot)*a + Math.cos(rot)*b )
          };
        }
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            var sndChannel:SoundChannel=new SoundChannel();
            sndChannel = snd.play(0, 5);
            
        }
        
        private function FFTswitcher(e:MouseEvent):void 
        {
            if (FFTswitch) { FFTswitch = false; } else { FFTswitch = true;}
        }
            
    }
}

class Camera{
    public var forcus:Number = 450;
    public var zoom:Number = 1.5;
    public var rotationX:Number = 0;
    public var rotationY:Number = 0;
    public var rotationZ:Number = 0;
}

class Star{
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    
    public var life:Number = 240;
    public var mass:Number = 1;
}