/**
 * Copyright irgaly ( http://wonderfl.net/user/irgaly )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nsQW
 */


// Spriteのサイズを調査します
//
// とはいえ
// http://www40.atwiki.jp/spellbound/pages/335.html
// を見ると、Spriteのサイズはかなり動的で、描かれている内容や子オブジェクトの影響をうけて変動します。
// あまりSpriteのサイズは気にせずに使ったほうが良さそうですね。

package {
    import flash.text.*;
    import flash.display.Sprite;
    public class SpriteTest extends Sprite {
        private var _textY:Number = 0;
        public function SpriteTest() {
            var sprite:Sprite = new Sprite();
            sprite.x = 200;
            sprite.y = 0;
            addChild(sprite);

            // 初期値
            addText("[初期値]");
            addText("width: " + sprite.width);
            addText("height: " + sprite.height);
            
            // Spriteのサイズを超える図形を描いてみる
            sprite.graphics.beginFill(0xFF0000);
            sprite.graphics.drawRect(0, 0, 30, 30);
            sprite.graphics.endFill();
            addText("[Spriteのサイズを超える図形を描いたあと]");
            addText("width: " + sprite.width);
            addText("height: " + sprite.height);
            
            // Spriteよりも小さな図形を描いてみる
            sprite.graphics.beginFill(0x00FF00);
            sprite.graphics.drawRect(0, 0, 10, 10);
            sprite.graphics.endFill();
            addText("[Spriteのサイズよりも小さな図形を描いたあと]");
            addText("width: " + sprite.width);
            addText("heigth: " + sprite.height);
        }
        
        private function addText(text:String):void{
            var t:TextField = new TextField();
            t.autoSize = TextFieldAutoSize.LEFT;
            t.y = _textY;
            _textY += 20;
            t.text = text;
            addChild(t);
        }
    }
}