/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nsIC
 */

package {
  import com.actionscriptbible.Example;
  
  public class ch4ex6 extends Example {
    public function ch4ex6() {
      var powerStrip:PowerStrip = new PowerStrip();
      var heater:Heater = new Heater(10);
      var toaster:Toaster = new Toaster();
      var readingLamp:Lamp = new Lamp(25);
      var overheadLamp:Lamp = new Lamp(60);
      powerStrip.addAppliance(heater);
      powerStrip.addAppliance(toaster);
      powerStrip.addAppliance(readingLamp);
      powerStrip.addAppliance(overheadLamp);
      toaster.toast(new Bread()); //nothing happens
      powerStrip.turnOn(120); 
      //it gets warmer! it gets brighter! it gets brighter!
      trace(powerStrip.getPowerUse()); //1285
      toaster.toast(new Bread()); //your bread gets toasty
      trace(powerStrip.getPowerUse()); //1385
      powerStrip.turnOff();
      //it gets cold. it gets darker. it gets darker.
    }
  }
}

interface IPowerable {
  function turnOn(volts:Number):void;
  function turnOff():void;
  function getPowerUse():Number;
}

class Lamp implements IPowerable {
  private var watts:Number;
  private var isOn:Boolean;
  
  public function Lamp(wattage:Number) {
    watts = wattage;
    isOn = false;
  }
  
  public function turnOn(volts:Number):void {
    isOn = true;
    trace("it gets brighter!");
  }
  
  public function turnOff():void {
    isOn = false;
    trace("it gets darker.");
  }
  
  public function getPowerUse():Number {
    return (isOn)? watts : 0;
  }
}

class PowerStrip implements IPowerable {
  private var appliances:Array;
  
  public function PowerStrip() {
    appliances = new Array();
  }
  
  public function addAppliance(appliance:IPowerable):void {
    appliances.push(appliance);
  }
  
  public function turnOn(volts:Number):void {
    for each (var appliance:IPowerable in appliances) {
      appliance.turnOn(volts);
    }
  }
  
  public function turnOff():void {
    for each (var appliance:IPowerable in appliances) {
      appliance.turnOff();
    }
  }
  
  public function getPowerUse():Number {
    var powerDraw:Number = 0;
    for each (var appliance:IPowerable in appliances) {
      powerDraw += appliance.getPowerUse();
    }
    return powerDraw;
  }
}

class Heater implements IPowerable {
  private var amps:Number;
  private var volts:Number;
  
  public function Heater(amperage:Number) {
    amps = amperage;
    volts = 0;
  }
  
  public function turnOn(volts:Number):void {
    trace("it gets warmer!");
    this.volts = volts;
  }
  
  public function turnOff():void {
    trace("it gets cold.");
    volts = 0;
  }
  
  public function getPowerUse():Number {
    return volts * amps;
  }
}

class Toaster implements IPowerable {
  private var isOn:Boolean;
  private var isToasting:Boolean;
  
  public function turnOff():void {
    isOn = false;
    isToasting = false;
  }
  
  public function getPowerUse():Number {
    if (isToasting) {
      return 100;
    } else { 
      return 0;
    }
  }
  
  public function turnOn(volts:Number):void {
    isOn = true;
  }
  
  public function toast(pieceOfBread:Bread):Bread {
    if (!isOn) {
      trace("nothing happens");
      return pieceOfBread;
    }
    trace("your bread gets toasty");
    isToasting = true;
    pieceOfBread.toastiness += 10;
    return pieceOfBread;
  }
}

class Bread {
  public var toastiness:Number = 0;
}