/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ns3m
 */

package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    /**
     * これにインスパイアされて https://chrome.google.com/extensions/detail/idkjdjficifbfjjkdkiimioljbloddpl
     * @author paq89
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
    public class Main extends Sprite 
    {
        public function Main():void 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            addChild(new Jimmy(this));
        }
    }
    
}

//----------------------------------------------------------

import flash.display.DisplayObjectContainer;
import flash.display.Loader;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.MouseEvent;
import flash.net.navigateToURL;
import flash.net.URLRequest;
import flash.system.Capabilities;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFieldType;
import flash.text.TextFormat;

//----------------------------------------------------------

/**
 * Jimmy クラスは簡単に Jimmy からのメッセージを表示するためのクラスです.
 * @author  paq89
 * @version 0．1
 * @since 2010/12/09
 */
class Jimmy extends Sprite
{
    //----------------------------------------------------------
    //   Constructor 
    //----------------------------------------------------------
    
    /**
     * 新しい Jimmy インスタンスを作成します.
     * 
     * @param layer Jimmy を表示する DisplayObjectContainer を指定します.
     */
    public function Jimmy(layer:DisplayObjectContainer)
    {
        super();
        _layer = layer;
        initialize();
    }
    
    //----------------------------------------------------------
    //   Property 
    //----------------------------------------------------------
    
    private const MESSAGE:Object = {
        "cs": "Přečtěte si:\nOsobní prosba\nzakladatele Wikipedie, Jimmyho Walese",
        "da": "Læs:<br>en personlig opfordring fra\nWikipedias grundlægger Jimmy Wales",
        "nl": "Lees alstublieft<br>mijn persoonlijke oproep!\nJimmy Wales, oprichter van Wikipedia.",
        "en": "Please read: A personal appeal from Wikipedia founder Jimmy Wales",
        "fi": "Ole hyvä ja lue:<br>Henkilökohtainen pyyntö\nWikipedian perustaja Jimmy Walesilta",
        "fr": "Lisez l'appel personnel<br>de Jimmy Wales,\nfondateur de Wikipédia",
        "de": "Bitte lesen:<br>Ein persönlicher Aufruf von\nWikipedia-Gründer Jimmy Wales",
        "hu": "Kérlek, olvasd el<br>Jimmy Wales Wikipédia-alapító\nszemélyes felhívását!",
        "it": "Per favore, leggi:<br>un appello personale del\nfondatore di Wikipedia Jimmy Wales",
        "ja": "ウィキペディア創設者\nジミー・ウェールズからの\nメッセージをお読みください",
        "no": "<br>En personlig appell fra\nWikipedia-grunnlegger Jimmy Wales",
        "pl": "Przeczytaj<br>osobisty apel\nJimmy'ego Walesa, założyciela Wikipedii.",
        "pt": "Por favor leia:<br>Um apelo pessoal de\nJimmy Wales, fundador da Wikipédia",
        "ru": "Пожалуйста, прочтите:<br>Личное обращение\nоснователя Википедии Джимми Уэйлса",
        "es": "Por favor, lee:<br>Una petición personal\ndel fundador de Wikipedia, Jimmy Wales",
        "sv": "Läs vad Wikipedias grundare<br>Jimmy Wales\nhar att säga",
        "zh-CN": "请阅读：<br>维基百科创办人吉米·威尔士\n所写的公开信",
        "zh-TW": "請閱讀︰\n維基百科創辦人吉米·威爾斯\n所寫的公開信"
    };
    
    private const BACKGROUND_IMAGE_URL:String = "http://upload.wikimedia.org/centralnotice/images/Jimmy-window-light.jpg";
    
    private var _loader:Loader;
    private var _textField:TextField;
    private var _layer:DisplayObjectContainer;
    private var _container:Sprite;
    private var _language:String;
    
    //----------------------------------------------------------
    //   Event 
    //----------------------------------------------------------
    
    /**
     * @param event
     */
    private function onClick(event:MouseEvent):void 
    {
        navigateToURL(new URLRequest("http://wikimediafoundation.org/w/index.php?title=WMFJA1/" + _language), "_blank")
    }
    
    /**
     * @param event
     */
    private function onResize(event:Event):void 
    {
        _loader.x = _layer.stage.stageWidth - 3000;
    }
    
    //----------------------------------------------------------
    //   Function 
    //----------------------------------------------------------
    
    /**
     * 初期化します.
     */
    protected function initialize():void 
    {
        _container = new Sprite();
        _loader = new Loader();
        _textField = new TextField();
        
        _container.addChild(_loader);
        _container.addChild(_textField);
        addChild(_container);
        
        _textField.mouseEnabled  = false;
        buttonMode = true;
        useHandCursor = true;
        
        _language = Capabilities.language;

        // イベントリスナー
        addEventListener(MouseEvent.CLICK, onClick);
        _layer.stage.addEventListener(Event.RESIZE, onResize);
        
        createBackgroundImage();
        createMessageText();
    }
    
    /**
     * 背景画像を読み込みます.
     */
    protected function createBackgroundImage():void 
    {
        _loader.x = _layer.stage.stageWidth - 3000;
        _loader.load(new URLRequest(BACKGROUND_IMAGE_URL));
    }
    
    /**
     * Jimmy からのメッセージを作成します.
     */
    protected function createMessageText():void 
    {
        var format:TextFormat = new TextFormat();
        format.size = 28;
        format.color = 0x333333;
        format.font = getFontName();
        
        _textField.defaultTextFormat = format;
        
        _textField.text = getMessage();
        _textField.border = false;
        _textField.type = TextFieldType.DYNAMIC;
        _textField.selectable = false;
        _textField.x = 20;
        _textField.y = 20;
        _textField.autoSize = TextFieldAutoSize.LEFT;
    }
    
    /**
     * OS に合わせたフォント名を取得します.
     * @return フォント名
     */
    protected function getFontName():String 
    {
        var os:String = Capabilities.os;
        var font:String = "";
        if (os.slice(0, 3) == "Mac")
        {
            font = "ヒラギノ角ゴ Pro W3";
        }
        else if (os.slice(0, 3) == "Win")
        {
            if (os.indexOf("7") || os.indexOf("Vista"))
            {
                font = "メイリオ";
            }
            else
            {
                font = "ＭＳ Ｐゴシック";
            }
        }
        else
        {
            font = "sans-serif";
        }
        
        return font;
    }
    
    /**
     * Jimmy からのメッセージを取得します.
     * @return Jimmy からのメッセージ
     */
    public function getMessage():String 
    {
        if (MESSAGE[_language] == undefined)
        {
            return MESSAGE["en"];
        }
        return MESSAGE[_language];
    }
}