/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nqP2
 */

// double click the stage to toggle visibility of the
// vézier curve and auxiliary lines

package
{
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Bezier extends Sprite
    {
        private var lineCanvas:Shape;
        private var g:Graphics;
        private var points:Vector.<Sprite>;
        private var division:int;
        private var displayMode:int;
        
        
        public function Bezier()
        {
            lineCanvas = new Shape();
            addChild(lineCanvas);
            
            g = lineCanvas.graphics;
            
            points = new Vector.<Sprite>();
            for (var i:int = 0; i < 3; i++) {
                points[i] = new Sprite();
                points[i].buttonMode = true;
                
                points[i].graphics.lineStyle(0, 0x3F << (i == 0 ? 16 : (i == 1 ? 8 : 0)));
                points[i].graphics.beginFill(0x5F << (i == 0 ? 16 : (i == 1 ? 8 : 0)), 0.5);
                points[i].graphics.drawCircle(0, 0, 6);
                
                points[i].x = Math.cos((i * 4 - 3) / 6 * Math.PI) * 200 + stage.stageWidth / 2;
                points[i].y = Math.sin((i * 4 - 3) / 6 * Math.PI) * 200 + stage.stageHeight / 2;
                addChild(points[i]);
            }
            
            division = 10;
            
            displayMode = 0;
            
            stage.doubleClickEnabled = true;
            update();
            
            
            stage.addEventListener(MouseEvent.DOUBLE_CLICK, function(e:MouseEvent):void
            {
                displayMode++;
                if (displayMode > 2) displayMode = 0;
                update();
            });
            
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void
            {
                if (e.target != stage) e.target.startDrag();
                stage.addEventListener(Event.ENTER_FRAME, update);
            });
            
            
            stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void
            {
                for (i = 0; i < 3; i++) points[i].stopDrag();
                stage.removeEventListener(Event.ENTER_FRAME, update);
            });
        }
        
        
        private function update(e:Event = null):void
        {
            g.clear();
            
            var abXd:Number = (points[1].x - points[0].x) / division;
            var abYd:Number = (points[1].y - points[0].y) / division;
            var bcXd:Number = (points[2].x - points[1].x) / division;
            var bcYd:Number = (points[2].y - points[1].y) / division;
            
            if(displayMode!=1){
                for (var i:int = 1; i < division; i++) {
                    var dX:Number = abXd * i + points[0].x;
                    var dY:Number = abYd * i + points[0].y;
                    var eX:Number = bcXd * i + points[1].x;
                    var eY:Number = bcYd * i + points[1].y;
                    
                    g.lineStyle(0, 0x3F3F3F);
                    g.moveTo(dX, dY);
                    g.lineTo(eX, eY);
                    g.lineStyle();
                    
                    g.beginFill(0x5F5F5F, 0.5);
                    g.drawCircle((eX - dX) / division * i + dX, (eY - dY) / division * i + dY, 3);
                    g.endFill();
                }
            }
            
            g.moveTo(points[0].x, points[0].y);
            g.lineStyle(2, 0x3F3F00);
            g.lineTo(points[1].x, points[1].y);
            g.lineStyle(2, 0x003F3F);
            g.lineTo(points[2].x, points[2].y);
            g.lineStyle(2, 0x3F003F);
            if (displayMode < 2) g.curveTo(points[1].x, points[1].y, points[0].x, points[0].y);
        }
    }
}