/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nq5J
 */

// original written by j.tarbel
// http://www.complexification.net/gallery/machines/deeplorenz/

package {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(backgroundColor="#ffffff", frameRate="30")]

	public class DeepLorenz extends Sprite {

		private var x0:Number;
		private var y0:Number;
		private var z0:Number;
		private var a:Number = 10;
		private var b:Number = 28;
		private var c:Number = 8/3;
		private var h:Number = 0.01;
		private var scale:Number;
		private var bitmap:BitmapData;

		public function DeepLorenz() {
			stage.align = "TL";
			stage.scaleMode = "noScale";

			scale = Math.min(stage.stageWidth, stage.stageHeight) / 300;
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffff);
			addChild(new Bitmap(bitmap));
			addEventListener(Event.ENTER_FRAME, draw);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, init);
			init(null);
		}

		public function init(e:MouseEvent):void {
			x0 = (Math.random() - 0.5) * 25;
			y0 = 1;
			z0 = Math.random() * 25;
			bitmap.fillRect(bitmap.rect, 0xffffff);
		}

		public function draw(e:Event):void {
			var x1:Number = x0 + h * a * (y0 - x0);
			var y1:Number = y0 + h * (x0 * (b - z0) - y0);
			var z1:Number = z0 + h * (x0 * y0 - c * z0);
			var s:Shape = new Shape();
			s.graphics.lineStyle(0, 0x000000, 0.2);
			s.graphics.drawCircle(x1 * scale * 6, y1 * scale * 6, z1 * scale);
			bitmap.draw(s, new Matrix(1, 0, 0, 1, stage.stageWidth / 2, stage.stageHeight / 2));
			x0 = x1;
			y0 = y1;
			z0 = z1;
		}

	}
}
