/**
 * Copyright staticmh ( http://wonderfl.net/user/staticmh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/npsX
 */

// forked from staticmh's flash on 2011-12-28
// forked from yanbaka's HANABI ランダムに色を追加してみました。
// 色々参考にさせて頂いてます
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.Timer;
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
    
    public class Hanabi extends Sprite
    {
        private const WIDTH:Number = 465;
        private const HEIGH:Number = 465;
        
        private var _particles:Array;
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _rect:Rectangle;
        private var cTra:ColorTransform;
        private var timer:Timer;
        
        private var sx:Number;
        private var sy:Number;
        
        private var perlineNoiseBMD:BitmapData;
        private var size:Number=1.3;
        
        public function Hanabi()
        {
            init();
        }
        
        private function init():void
        {
            _particles = [];
            _canvas = new BitmapData(WIDTH, HEIGH, false, 0x0);
            addChild(new Bitmap(_canvas)) as Bitmap;
            
            _glow = new BitmapData(WIDTH/4, HEIGH/4, false, 0x0);
            var bm:Bitmap = addChild(new Bitmap(_glow, PixelSnapping.NEVER, true)) as Bitmap;
            bm.scaleX = bm.scaleY = 5;
            bm.blendMode = BlendMode.ADD;
            
            _rect = new Rectangle(0, 0, WIDTH, HEIGH);
            cTra = new ColorTransform(.9, .85, .8, 1.0);
            
            this.stage.addEventListener(Event.ENTER_FRAME, enterframeHandler);
            
            timer = new Timer(300);
            timer.addEventListener(TimerEvent.TIMER, resetFunc);
            timer.start();
            
            perlineNoiseBMD = new BitmapData(100, 100, false, 0x000000);
            perlineNoiseBMD.perlinNoise(100, 100, 7, 1, true, true);
            
            
        }
        
        private function resetFunc(e:TimerEvent):void
        {
            (cTra.redMultiplier > 0.9)? cTra.redMultiplier = 0.8 : cTra.redMultiplier += 0.01;
            
            hanabi();
        }
        
        private function hanabi():void 
        {
            var i:int = 200;
            sx = Math.random()*WIDTH;
            sy = Math.random() * HEIGH / 3;
            var cx:Number = Math.random() * 100;
            var cy:Number = Math.random() * 100;
            while (i--) createParticle(cx,cy);
        }
        
        private function createParticle(cx:Number,cy:Number):void {
            var p:Particle = new Particle();
            p.x = sx;
            p.y = sy;
            var radius:Number = Math.sqrt(Math.random())*10;
            var angle:Number = Math.random()*(Math.PI)*2;
            p.vx = Math.cos(angle) * radius;
            p.vy = Math.sin(angle) * radius;
            _particles.push(p);
        
            p.c = new Rectangle(cx, cy, size, size);
            
            
            
        }
        
        private function enterframeHandler(e:Event):void
        {
            update();
        }
        
        private function update():void {
            _canvas.lock();
            _canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(1, 1));
            _canvas.colorTransform(_rect, cTra);
            var i:int = _particles.length;
            while (i--) {
                var p:Particle = _particles[i];
                p.vy += 0.1;
                p.vx *= 0.9;
                p.vy *= 0.9;
                p.x += p.vx;
                p.y += p.vy;
                
                _canvas.copyPixels(perlineNoiseBMD, p.c, new Point(p.x, p.y));
                
                if ((p.x > stage.stageWidth || p.x < 0) || (p.y > stage.stageHeight) || Math.abs(p.vx) < .005 || Math.abs(p.vy) < .005)
                {
                    this._particles.splice(i, 1);
                }
            }
            
            _glow.draw(_canvas, new Matrix(0.2, 0, 0, 0.2));
                        _canvas.unlock();
                        
        }
    }
}

import flash.geom. * ;
class Particle
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var c:Rectangle;
    
    public function Particle() {}
}

