/**
 * Copyright mattodesign ( http://wonderfl.net/user/mattodesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/npNe
 */

//練習
//Flash Math & Physics Design:ActionScript 3.0による数学・物理学表現[入門編]
//http://www.amazon.co.jp/Flash-Math-Physics-Design-3-0%E3%81%AB%E3%82%88%E3%82%8B%E6%95%B0%E5%AD%A6%E3%83%BB%E7%89%A9%E7%90%86%E5%AD%A6%E8%A1%A8%E7%8F%BE/dp/4797351411
package {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.events.MouseEvent;
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#FFFFFF")]
	public class Roulette extends MovieClip {
		//プロパティ宣言
		private var toAngle:Number = 0;
		private var curAngle:Number = 0;
		private var preAngle:Number = 0;
		private var timer:Timer;
		private var startBt:Sprite;
		private var roulette:Sprite;
		private var bgObj:Sprite;
		private var numberObj:Number = 10;
		private var circleSize:Number = 45;
		
		//コンストラクタメソッド
		public function Roulette():void {
			var obj:Array = new Array();
			var koko:Point = new Point();
			var hankei:Number = 150;
			var radian:Number = (Math.PI * 2) / numberObj;
			var Symbol:Sprite;
			var objName:TextField;
			var startName:TextField;
			var formatNumber:TextFormat;
			//ルーレット終了の合図のためのシンボル
			bgObj = new Sprite();
			bgObj.graphics.beginFill(0x000000);
			bgObj.graphics.drawRect(0, 0, stage.stageWidth,stage.stageHeight);
			addChild(bgObj);
			//番号分のシンボル作成
			for (var i:Number = 0; i < numberObj; i++) {
				Symbol = new Sprite();
				Symbol.graphics.beginFill(0xFFFFFF);
				Symbol.graphics.drawCircle(0, 0, circleSize);
				obj.push(Symbol);
				obj[i].x = this.stage.stageWidth / 2;
				obj[i].y = this.stage.stageHeight / 2;
				addChild(obj[i]);
				//番号シンボルのテキスト設定
				formatNumber = new TextFormat();
				formatNumber.font = "Arial";
				formatNumber.size = 40;
				formatNumber.bold = true;
				objName = new TextField();
				objName.text = String(i + 1);
				objName.setTextFormat(formatNumber);
				objName.x = -(objName.textWidth / 2) - 1;
				objName.y = -objName.textHeight / 2;
				objName.selectable = false;
				obj[i].addChild(objName);
				koko.x = obj[i].x + hankei * Math.sin(radian * i);
				koko.y = obj[i].y - hankei * Math.cos(radian * i);
				obj[i].x = koko.x;
				obj[i].y = koko.y;
			}
			//STARTシンボル作成
			startBt = new Sprite();
			startBt.graphics.beginFill(0x31C4F5);
			startBt.graphics.drawCircle(0, 0, 30);
			startBt.x = stage.stageWidth / 2;
			startBt.y = stage.stageHeight / 2;
			addChild(startBt);
			//STARTシンボルのテキスト設定
			var formatStart:TextFormat = new TextFormat();
			formatStart.font="Arial";
			formatStart.size = 16;
			formatStart.bold = true;
			formatStart.color = 0xFFFFFF;
			startName = new TextField();
			startName.text = "START";
			startName.setTextFormat(formatStart);
			startName.x = -(startName.textWidth / 2) - 2;
			startName.y = -startName.textHeight / 2;
			startName.autoSize = TextFieldAutoSize.LEFT;
			startName.selectable = false;
			startBt.addChild(startName);
			startBt.buttonMode = true;
			startBt.mouseChildren = false;
			startBt.useHandCursor = true;
			startBt.addEventListener(MouseEvent.CLICK, onMClick);
			//ルーレットシンボル作成
			roulette = new Sprite();
			roulette.graphics.lineStyle(8, 0xFF0000);
			roulette.graphics.drawCircle(0, -150, circleSize);
			addChild(roulette);
			roulette.x = stage.stageWidth / 2;
			roulette.y = stage.stageHeight / 2;
			timer = new Timer(33);
			timer.addEventListener(TimerEvent.TIMER, loop);
			timer.start();
		}
		
		private function onMClick(event:MouseEvent):void {
			toAngle += 720 + Math.floor(Math.random() * numberObj) * (360 / numberObj);
			}
		
		private function loop(event:TimerEvent):void {
			preAngle = curAngle;
			curAngle += (toAngle - curAngle) / 30;
			roulette.rotation = curAngle;
			if (toAngle - curAngle < 1) {
				if (toAngle - preAngle >= 1) {
					bgObj.alpha = 0.5;
					curAngle = toAngle;
					}
				}else {
					bgObj.alpha = 1;
					}
			}
	}
	
}