/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/npMw
 */

package 
{
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author jaiko
     */
    public class Main2 extends Sprite 
    {
        
        public function Main2():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var bg:Shape = new Shape();
            addChild(bg);
            var g:Graphics;
            g = bg.graphics;
            g.beginGradientFill(GradientType.LINEAR,
            [0x000000    , 0x666666,0],
            [1            ,1,1],
            [0            , 125, 255],
            new Matrix(0, 1, 1, 0, 0, 0)
            );
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            var viewManager:ViewManager = new ViewManager();
            addChild(viewManager);
            addChild(new Stats());
        }
    }
}
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
/**
 * ...
 * @author jaiko
 */
class ViewManager extends Sprite 
{
    private var dragRing:Ring;
    public function ViewManager() 
    {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point    
        stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDwonListener);
        addEventListener(RingEvent.DELETE_RING, ringDeleteListner,true);
    }
    
    private function ringDeleteListner(event:RingEvent):void 
    {
        var ring:Ring = event.ring;
        removeChild(ring);
    }
    private function mouseDwonListener(event:MouseEvent):void 
    {
        
        dragRing = new Ring();
        addChild(dragRing);
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
    }
    
    private function mouseUpListener(event:MouseEvent):void 
    {
        dragRing.mouseUp();
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.Point;
import flash.utils.setInterval;
/**
 * ...
 * @author jaiko
 */
class Ring extends Sprite
{
    private const OUTER_RADIUS:Number = 10;
    private const INNER_RADIUS:Number = 9;
    private const K:Number = 0.08;
    private const K_RING:Number = 0.05;
    private const U:Number = 0.08;
    private const U_RING:Number = 0.08;
    private const F:Number = 3;
    private const SPRIT:uint = 120;
    private const COLOR:Number = 0xFFFFDD;
    private var pointList:Array;
    private var innerList:Array;
    private var ringSprite:Sprite;
    private var vx:Number = 0;
    private var vy:Number = 0;
    public function Ring() 
    {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    public function mouseUp():void 
    {
        removeEventListener(Event.ENTER_FRAME, dragMoveEnterFrameListener);
        //
        shuffleMove();
        addEventListener(Event.ENTER_FRAME, floatEnterFrameListener);
    }
    private function floatEnterFrameListener(event:Event):void
    {
        vx *= 0.95;
        vy += -0.05;
        ringSprite.x += vx;
        ringSprite.y += vy;
        
        if (ringSprite.y < -100)
        {
            removeEventListener(Event.ENTER_FRAME, floatEnterFrameListener);
            removeEventListener(Event.ENTER_FRAME, ringEnterFrameListener);
            var ringEvent:RingEvent = new RingEvent(RingEvent.DELETE_RING,true);
            ringEvent.ring = this;
            dispatchEvent(ringEvent);
        }
    }
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point
        addEventListener(Event.ENTER_FRAME, dragMoveEnterFrameListener);
        addEventListener(Event.ENTER_FRAME, ringEnterFrameListener);
        //
        var ringPoint:RingPoint;
        var _x:Number;
        var _y:Number;
        var point:Point;
        var theta:Number;
        var n:uint;
        var i:uint;
        var g:Graphics;
        ringSprite = new Sprite();
        addChild(ringSprite);
        ringSprite.x = mouseX;
        ringSprite.y = mouseY;
        g = ringSprite.graphics;
        g.beginFill(COLOR);
        pointList = [];
        innerList = [];
        n = SPRIT;
        for (i = 0; i < n; i++)
        {
            theta = 2 * Math.PI * (i / n);
            _x = OUTER_RADIUS * Math.cos(theta);
            _y = OUTER_RADIUS * Math.sin(theta);
            
            ringPoint = new RingPoint();
            addChild(ringPoint);
            ringPoint.theta = theta;
            ringPoint.x = stage.mouseX + _x;
            ringPoint.y = stage.mouseY + _y;
            pointList[i] = ringPoint;
            //
            _x = INNER_RADIUS * Math.cos(theta);
            _y = INNER_RADIUS * Math.sin(theta);
            ringPoint = new RingPoint();
            addChild(ringPoint);
            ringPoint.theta = theta;
            ringPoint.x = stage.mouseX + _x;
            ringPoint.y = stage.mouseY + _y;
            innerList[i] = ringPoint;
        }
        var glow:GlowFilter = new GlowFilter(COLOR, 0.8, 16, 16,16);
        var blur:BlurFilter = new BlurFilter(16, 16);
        this.filters = [glow,blur];
        this.alpha = 0.5;        
    }
    private function shuffleMove():void
    {
        var i:uint;
        var n:uint;
        var random:Number;
        var point:RingPoint;
        var v:Number;
        random = 2 * Math.PI * Math.random();
        v = 2 + 5 * Math.random();
        vx = v * Math.cos(random);
        vy = v * Math.sin(random);
        n = pointList.length
        for (i - 0; i < n; i++)
        {
            point = pointList[i];
            point.vx = 30 * Math.cos(random);
            point.vy = 30 * Math.sin(random);
            point = innerList[i];
            point.vx = 30 * Math.cos(random);
            point.vy = 30 * Math.sin(random);
        }
    }
    private function dragMoveEnterFrameListener(event:Event):void
    {
        var k:Number = 0.08;
        var u:Number = 0.2;
        var ax:Number = k * (stage.mouseX - ringSprite.x);
        var ay:Number = k * (stage.mouseY - ringSprite.y);
        vx += ax - u * vx;
        vy += ay - u * vy;
        ringSprite.x += vx;
        ringSprite.y += vy;
    }
    private function ringEnterFrameListener(event:Event):void 
    {
        var theta:Number;
        var ax:Number;
        var ay:Number;
        var pax:Number
        var pay:Number;
        var bax:Number;
        var bay:Number;
        var previousPoint:RingPoint;
        var currentPoint:RingPoint;
        var nextPoint:RingPoint;
        var targetX:Number;
        var targetY:Number;
        var currentX:Number;
        var currentY:Number;
        var i:uint;
        var n:uint;
        var g:Graphics
        g = this.graphics;
        g.clear();
        g.beginFill(COLOR);
        //
        n = pointList.length;
        for (i = 0; i < n; i++)
        {
            //外壁について
            currentPoint = pointList[i];
            //膨張
            theta = Math.atan2( currentPoint.y - ringSprite.y, currentPoint.x -ringSprite.x );
            ax = F * Math.cos(theta);
            ay = F * Math.sin(theta);
            currentPoint.vx += ax;
            currentPoint.vy += ay;
            //前ポイントとの計算
            if (i == 0) {
                previousPoint =  pointList[n - 1];
            }else {
                previousPoint =  pointList[i-1];
            }
            pax = K_RING * (previousPoint.x - currentPoint.x);
            pay = K_RING * (previousPoint.y - currentPoint.y);
            //後ポイントと計算
            if (i == n-1) {
                nextPoint =  pointList[0];
            }else {
                nextPoint =  pointList[i+1];
            }
            bax = K_RING * (nextPoint.x - currentPoint.x);
            bay = K_RING * (nextPoint.y - currentPoint.y);
            currentPoint.vx += (pax + bax) - U_RING * currentPoint.vx;
            currentPoint.vy += (pay + bay) - U_RING * currentPoint.vy;
            //リング全体の動き
            ax = K * ((ringSprite.x + OUTER_RADIUS * Math.cos(currentPoint.theta)) - currentPoint.x );
            ay = K * ((ringSprite.y + OUTER_RADIUS * Math.sin(currentPoint.theta)) - currentPoint.y );
            currentPoint.vx += ax - U * currentPoint.vx;
            currentPoint.vy += ay - U * currentPoint.vy;
            currentPoint.x += currentPoint.vx;
            currentPoint.y += currentPoint.vy;
            //外壁の描写
            if (i == 0) {
                g.moveTo(currentPoint.x ,currentPoint.y);
            }else {
                g.lineTo(currentPoint.x, currentPoint.y);                    
            }
            //外壁と同様に内壁の計算
            currentPoint = innerList[i];
            //膨張
            theta = Math.atan2( currentPoint.y - ringSprite.y, currentPoint.x -ringSprite.x );
            ax = F * Math.cos(theta);
            ay = F * Math.sin(theta);
            currentPoint.vx += ax;
            currentPoint.vy += ay;
            //前ポイントとの計算
            if (i == 0) {
                previousPoint =  innerList[n - 1];
            }else {
                previousPoint =  innerList[i-1];
            }
            pax = K_RING * (previousPoint.x - currentPoint.x);
            pay = K_RING * (previousPoint.y - currentPoint.y);
            //後ポイントと計算
            if (i == n-1) {
                nextPoint =  innerList[0];
            }else {
                nextPoint =  innerList[i+1];
            }
            bax = K_RING * (nextPoint.x - currentPoint.x);
            bay = K_RING * (nextPoint.y - currentPoint.y);
            //
            currentPoint.vx += (pax + bax) - U_RING * currentPoint.vx;
            currentPoint.vy += (pay + bay) - U_RING * currentPoint.vy;
            //
            ax = K * ((ringSprite.x + INNER_RADIUS * Math.cos(currentPoint.theta)) - currentPoint.x );
            ay = K * ((ringSprite.y + INNER_RADIUS * Math.sin(currentPoint.theta)) - currentPoint.y );
            currentPoint.vx += ax - U * currentPoint.vx;
            currentPoint.vy += ay - U * currentPoint.vy;
            
            currentPoint.x += currentPoint.vx;
            currentPoint.y += currentPoint.vy;
        }
        //内壁の描画
        for (i = 0; i < n; i++)
        {
            currentPoint = innerList[i];
            if (i == 0) {
                g.moveTo(currentPoint.x ,currentPoint.y);
            }else {
                g.lineTo(currentPoint.x, currentPoint.y);                    
            }
        }
    }
}
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
/**
 * ...
 * @author jaiko
 */
class RingPoint extends Sprite
{
    private var _theta:Number;
    private var _px:Number;
    private var _py:Number;
    private var _vx:Number = 0;
    private var _vy:Number = 0;
    public function RingPoint() 
    {
    }
    public function get px():Number 
    {
        return _px;
    }
    
    public function set px(value:Number):void 
    {
        _px = value;
    }
    
    public function get py():Number 
    {
        return _py;
    }
    
    public function set py(value:Number):void 
    {
        _py = value;
    }
    
    public function get vx():Number 
    {
        return _vx;
    }
    
    public function set vx(value:Number):void 
    {
        _vx = value;
    }
    
    public function get vy():Number 
    {
        return _vy;
    }
    
    public function set vy(value:Number):void 
    {
        _vy = value;
    }
    
    public function get theta():Number 
    {
        return _theta;
    }
    
    public function set theta(value:Number):void 
    {
        _theta = value;
    }
}
import flash.events.Event;
/**
 * ...
 * @author jaiko
 */
class RingEvent extends Event 
{
    public static const DELETE_RING:String  = "delete_ring";
    public var ring:Ring;
    public function RingEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 
    { 
        super(type, bubbles, cancelable);
        
    } 
    
    public override function clone():Event 
    { 
        return new RingEvent(type, bubbles, cancelable);
    } 
    
    public override function toString():String 
    { 
        return formatToString("RingEvent", "type", "bubbles", "cancelable", "eventPhase"); 
    }
    
}