/**
 * Copyright yurij.shaulov ( http://wonderfl.net/user/yurij.shaulov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nnKI
 */

package{
import flash.display.DisplayObjectContainer;

import flash.display.Graphics;

import flash.display.Sprite;

import flash.events.MouseEvent;

import flash.events.Event;

import flash.geom.Point;

 public class Circle extends Sprite {

    public function get color():uint { return _color; }

    public function set color(value:uint):void {

        _color = value;

        draw();

    }

    private var _color:uint = 0x55FFFF;

    public function get radius():Number { return _radius; }

    public function set radius(value:Number):void {

        _radius = value;

        draw();

    }

    private var _radius:Number;

    

    //public function onMouseUp(e:MouseEvent):void {

        //stopDrag();

    //}

    public var onMouseUp:Function;

    

    public function Circle(    x:Number = 0, y:Number = 0 ,radius_:Number = 30) {

        this.x = x;

        this.y = y;

        //this._radius = radius;

        _circleView = new Sprite();

        addChild(_circleView);

        

        

        _circleView.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {

            startDrag();

        });

        _circleView.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void {

            stopDrag();

        });

        

        _scaleView = new Sprite();

        

        var sg:Graphics = _scaleView.graphics;

        sg.beginFill(0xFFCCCC);

        sg.drawRect( -5, -5, 5, 5);

        sg.endFill();

        _scaleView.y = +_scaleView.height / 2;

        addChild(_scaleView);

        

        

        var scaleOnEnterFrame :Function = function(e:Event):void {

            _scaleView.x = mouseX ;//+ _scaleView.width/2;

            radius = _scaleView.x ;//- _scaleView.width/2;

        }

        var scaling:Boolean = false;

        _scaleView.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {

            if (!scaling) {

                addEventListener(Event.ENTER_FRAME, scaleOnEnterFrame);

            }

            scaling = true;

        });

        

        _scaleView.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void {

            if (scaling) {

                removeEventListener(Event.ENTER_FRAME, scaleOnEnterFrame);

            }

            scaling = false;

        });

        this.radius = radius_;

        _scaleView.x = radius ;//+_scaleView.width / 2;

        

        onMouseUp = function(e:MouseEvent):void {

            stopDrag();

            if (scaling) {

                removeEventListener(Event.ENTER_FRAME, scaleOnEnterFrame);

            }

            scaling = false;

        };

    }

    private var _circleView:Sprite;

    private var _scaleView:Sprite;

    private function draw():void {

        var g:Graphics = _circleView.graphics;

        g.clear();

        g.beginFill(color,0.5);

        g.drawCircle(0, 0, radius);

        g.endFill();

    }

    public override function toString():String {

        return "new Circle("+x+","+y+","+radius+")";

    }

}
}