/**
 * Copyright foo9 ( http://wonderfl.net/user/foo9 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nnCk
 */

package {
    import net.wonderfl.widget.Wanco;
    
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.geom.ColorTransform;
    
    [SWF(backgroundColor = 0xFFFFFF, width = "465", height = "465", frameRate = 24)]
    
    public class WancoSample extends Sprite
    {   
        public static const SCREEN_HEIGHT:uint = 465;
        public static const SCREEN_WIDTH:uint = 465;
        public static const BG_HEIGHT:uint = SCREEN_HEIGHT;
        public static const BG_WIDTH:uint = SCREEN_WIDTH;   
        //public static const BG_HEIGHT:uint = 400;
        //public static const BG_WIDTH:uint = 200;     
        public static const BLOCK_HEIGHT:uint = 120;    
        public static const BLOCK_WIDTH:uint = 120;   
        
        public var wanco:Wanco;
        public var bg:Sprite;
        
        public function WancoSample()
        {
            stage.align = "";
            stage.scaleMode = StageScaleMode.NO_SCALE;

            bg = new Sprite();
            bg.graphics.beginFill(0xCCCCCC);
            bg.graphics.drawRect(0, 0, BG_WIDTH, BG_HEIGHT);
            bg.graphics.endFill();
            addChild(bg);
            
            wanco = new Wanco();
            wanco.width = BLOCK_WIDTH;
            wanco.height = BLOCK_HEIGHT;
            wanco.x = BLOCK_WIDTH * 0.5;
            wanco.y = BLOCK_HEIGHT;
            
            //色を変えたい
            var color:ColorTransform = new ColorTransform(1, 1, 1, 1, -255, 0, -255, 0);
　　　　　　　wanco.transform.colorTransform = color;
            bg.addChild(wanco);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
        }

        private function keyDownHandler(event:KeyboardEvent):void
        {
            switch(event.keyCode) {
                case 38: //↑ (上矢印)
                    if(wanco.y > BLOCK_HEIGHT) { 
                        wanco.y = wanco.y - BLOCK_HEIGHT;
                        wanco.sing();
                    }                       
                    break;                
                case 40: //↓ (下矢印)
                    if(wanco.y <= (BG_HEIGHT - BLOCK_HEIGHT)) { 
                        wanco.y = wanco.y + BLOCK_HEIGHT;
                        wanco.turn(); 
                    }             
                    break;                
                case 39: //→ (右矢印)
                    if(wanco.x < (BG_WIDTH - BLOCK_WIDTH)) {
                        wanco.x = wanco.x + BLOCK_WIDTH;
                        wanco.turnFace();
                    }              
                    break;
                case 37: //← (左矢印)
                    if(wanco.x >= BLOCK_WIDTH) { 
                        wanco.x = wanco.x - BLOCK_WIDTH;
                        wanco.walk();   
                    }           
                    break;
                default:
                    break;
            }  
        }
    }
}
 
