/**
 * Copyright zsp ( http://wonderfl.net/user/zsp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nmm0
 */

// forked from zsp's flash on 2009-6-11
package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.display.*;
    import flash.geom.*;
    import flash.events.Event;

    //[SWF(backgroundColor = "#FFFFFF", frameRate = 30)]
     [ SWF( width = "465" , height = "465" , backgroundColor = "0x000000" , frameRate = "60" ) ] 

    public class FlashTest extends Sprite {
        //private var tf:TextField;
        //private var screen:BitmapData = new BitmapData(465,400,true, 0x00000000);

        private var screen:BitmapData = new BitmapData(465,465,true,0x00000000);
        private var images:Vector.<BitmapData>;
        private var t:int = 0;
        private var balls: Vector.<Ball>;
        private const BL_NUM:int = 100;
        private const ROT_STEPS:int = 20;

        private var ct:ColorTransform = new ColorTransform(1,1,1,1,0,0,0,-12);

        public function FlashTest() {
            addChild(new Bitmap(screen));

            var sz: int = 5;
            var g_hsz : int = 8;        //half size of BitmapData
            var graph:Sprite = new Sprite();
            graph.graphics.lineStyle(1, 0xFFFFFF);
            graph.graphics.moveTo(-sz,-sz);
            graph.graphics.lineTo(-sz,sz);
            graph.graphics.lineTo(sz,0);
            graph.graphics.lineTo(-sz,-sz);
            //graph.graphics.drawCircle(0,0,5);

            graph.x = g_hsz;
            graph.y = g_hsz;

            var base :Sprite = new Sprite();

            base.addChild(graph);

            var source:BitmapData = new BitmapData(g_hsz*2, g_hsz*2, true, 0x00000000); 
            source.draw(base);

            addChild(base);


            images = new Vector.<BitmapData>();
            var i:int;
            for (i= 0; i<ROT_STEPS; i++){
                
                var matrix:Matrix; 
                matrix = new Matrix(); 
                matrix.translate( -g_hsz, -g_hsz);
                matrix.rotate(i *2*Math.PI/ ROT_STEPS)
                matrix.translate( g_hsz,g_hsz);

                var bmp:BitmapData = new BitmapData(g_hsz*2,g_hsz*2, true, 0x0000000);
                bmp.draw(source,matrix, null, null, null, true);
                images.push(bmp);
            }


            addEventListener(Event.ENTER_FRAME,mainloop);

            balls = new Vector.<Ball>;
            for(i=0; i<BL_NUM; i++){
                var b:Ball = new Ball();
                b.x = 233;
                b.y = 233;
                b.vx = Math.random()*2 -1;
                b.vy = Math.random()*2 -1;
                balls.push(b);
            }
         
        }
        public function mainloop(e:Event):void {
            t++;

            screen.lock();
            screen.fillRect(screen.rect, 0x00FFFFFF);

            screen.colorTransform(screen.rect, ct);

            var b:Ball;
            for (var i:int=0; i<BL_NUM; i++){
                b = balls[i];
                b.x += b.vx;
                b.y += b.vy;
                if(b.x<0) b.x += 465;
                if(465<b.x) b.x -=465;
                if(b.y<0) b.y += 465;
                if(465<b.y) b.y -=465;

                screen.copyPixels(images[(i+t)%ROT_STEPS],images[(i+t)%ROT_STEPS].rect, new Point(b.x,b.y),null,null,true);
            }

            screen.unlock(); 
       }
    }
}

   class Ball{
        public var x:Number;
        public var y:Number;
        public var vx:Number;
        public var vy:Number;
    }