/**
 * Copyright Geo877 ( http://wonderfl.net/user/Geo877 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nmFu
 */


//   Fire / Start : [Z], [X], [.] or [/] key.
package {
    import flash.display.Sprite;
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="30")]
    public class blob extends Sprite {
        public function blob() { main = this; initialize(); }
    }
}

import flash.display.*;
import flash.geom.*;
import flash.text.*;
import flash.events.*;
const SCREEN_WIDTH:int = 465, SCREEN_HEIGHT:int = 465;
var main:Sprite, g:Graphics;
var keys:Vector.<Boolean> = new Vector.<Boolean>(256);
var gravity:Number = 0.1;

var epi:MovieClip = new center_node();
	

function initialize():void {
	main.addEventListener(Event.ENTER_FRAME,mainLoop);
	
	main.addChild(epi);
	epi.x = 200;
	epi.y = 200;
	createNodes(15,30,epi);
}

function createNodes(n:Number,r:Number,center:MovieClip):void{
	var sn:Number = n;
	var angle:Number  =0;
	var angleInc:Number = ((Math.PI)*2)/n;
	while(n>0){
		var o_node:MovieClip = new outer_node();
		main.addChild(o_node);
		o_node.epi = center;
		center.o_nodes.push(o_node);
			
		o_node.x = (Math.cos(angle)*r)+center.x;
		o_node.y = (Math.sin(angle)*r)+center.y;
		angle+=angleInc;
		n--;
	}
	
	n = 0;
	while(n<sn){
		var A:Number = n-1;
		if(A<0){A=sn-1;}
		var B:Number = n+1;
		if(B>=sn){B = 0;}
		center.o_nodes[n].springNodeA = center.o_nodes[A];
		center.o_nodes[n].springNodeB = center.o_nodes[B];
		n++;
	}
}

function mainLoop(e:Event):void{
	epi.update();
}




/////////////////////////////////////////////////////////////////////////////////
class outer_node extends MovieClip {
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var epi:MovieClip;
	public var mass:Number = 3;
	public var springNodeA:MovieClip;
	public var springNodeB:MovieClip;
		public function outer_node(){
			graphics.beginFill(0x111111,1);
			graphics.drawCircle(0,0,3);
			graphics.endFill();
		}
		
		public function update():void{
			vy+=gravity;
			
			//spring away from center
			var dx:Number = epi.x - x;
			var dy:Number = epi.y - y;
			var d:Number = Math.sqrt(dx*dx+dy*dy);
			if(dx==0){dx = 0.0001;}
			if(d==0){d = 0.0001;}
			var xtoy:Number = dy/dx;
			var dtox:Number = dx/d;
			var f:Number = (20/d)/mass;
			//f/m =a 
			var newDx:Number = f*dtox;
			var newDy:Number = newDx*xtoy;
			vx-=newDx;
			vy-=newDy;
		
		
			//spring to paired node
			dx = springNodeA.x - x;
			dy = springNodeA.y - y;
			d = Math.sqrt(dx*dx+dy*dy);
			if(dx==0){dx = 0.0001;}
			if(d==0){d = 0.0001;}
			xtoy = dy/dx;
			dtox = dx/d;
			f = (20/d)/mass;
			//f/m =a 
			newDx = f*dtox;
			newDy = newDx*xtoy;
			//vx+=newDx;
			//vy+=newDy;
			
			//spring to B
			dx = springNodeB.x - x;
			dy = springNodeB.y - y;
			d = Math.sqrt(dx*dx+dy*dy);
			if(dx==0){dx = 0.0001;}
			if(d==0){d = 0.0001;}
			xtoy = dy/dx;
			dtox = dx/d;
			f = (20/d)/mass;
			//f/m =a 
			newDx = f*dtox;
			newDy = newDx*xtoy;
			//vx+=newDx;
			//vy+=newDy;
						
			x+=vx;
			y+=vy;
			if(y+width/2>465){
				y=465-width/2;
				vy *= -0.4;
			}
			if(x+width/2>465){
				x=465-width/2;
				vx *= -0.4;
			}
			if(x-width/2<0){
				x=width/2;
				vx *= -0.4;
			}
		}
}

class center_node extends MovieClip {
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var o_nodes:Array = new Array();
	public var mass:Number = 10;
		public function center_node():void{
			graphics.beginFill(0x000000,1);
			graphics.drawCircle(0,0,7);
			graphics.endFill();
		}
		
		public function update():void{
			vy+=gravity;
			
			updateNodes();
			
			x+=vx;
			y+=vy;
			if(y+width/2>465){
				y=465-width/2;
				vy *= -0.4;
			}
			
			if(x+width/2>465){
				x=465-width/2;
				vx *= -0.4;
			}
		}
		
		private function updateNodes():void{
			var i:Number = o_nodes.length-1;
			while(i>=0){
				var cur_o_nodes:MovieClip = o_nodes[i];
				cur_o_nodes.update();
				i--;
			}
		}
}