/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nmCp
 */

// forked from _53's HASEN（ポップ）
package {

    import flash.display.CapsStyle;
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;

    // import flash.display.LineScaleMode;

    [SWF(backgroundColor=0xffffff)]

    /**
    * 描画APIによるグラデーション線の描画方法のサンプル。
    * 同じカラー、異なるアルファを使用することで、破線を生み出す
    */
    public class Hasen extends Sprite {

        private var _currentShape:Shape;
        private var _color:uint;
        private var _startPosition:Point;

        /**
        * コンストラクタ。マウスイベントに関するリスナーを設定
        */
        public function Hasen() {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
            stage.addEventListener(MouseEvent.DOUBLE_CLICK, onStageMouseDoubleClick);
        }

        /**
        * 開始位置から現在のマウス位置まで、グラデーション線を描画
        */
        private function drawLine():void {
            var thickness:Number = 40;

            // 同じカラー
            var colors:Array = [_color, _color, 0xFFFFFF];
            // 異なるアルファ
            var alphas:Array = [1, 0, 1];
            // 同じ比率、つまり透明度が即座に変わる
            var ratios:Array = [127, 127, 127];


            // 開始位置と現在のマウス位置をもとに、線の角度を求める
            var currentPosition:Point = new Point(stage.mouseX, stage.mouseY);
            var xDist:Number = (currentPosition.x - _startPosition.x);
            var yDist:Number = (currentPosition.y - _startPosition.y);
            var angle:Number = Math.atan2(yDist, xDist);
            // 行列をグラデーションを回転させるために使用
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(thickness, thickness, angle);

            // グラデーション線の描画
            _currentShape.graphics.clear();
            _currentShape.graphics.lineStyle(thickness, 0, 1, false, null, CapsStyle.SQUARE);
            // nullの代わりに LineScaleMode.NONEを指定
            //_currentShape.graphics.lineStyle(thickness, 0, 1, false, LineScaleMode.NONE, CapsStyle.SQUARE);
            _currentShape.graphics.lineGradientStyle(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.REPEAT);
            _currentShape.graphics.moveTo(_startPosition.x, _startPosition.y);
            _currentShape.graphics.lineTo(stage.mouseX, stage.mouseY);
        }

        /**
        * ステージがクリックされたときのハンドラ。新しい線を描画するための新しいシェイプを追加し、
        * 線の開始位置を保持して、マウスの移動に関するリスナーを設定
        *
        * @param event ステージが送出するイベント
        */
        private function onStageMouseDown(event:MouseEvent):void {
            _color = Math.random()*0xFFFFFF;
            _currentShape = new Shape();
            addChild(_currentShape);
            _startPosition = new Point(stage.mouseX, stage.mouseY);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }

        /**
        * マウスが放されたときのハンドラ。マウスの移動に関するリスナーを削除
        *
        * @param event ステージが送出するイベント
        */
        private function onStageMouseUp(event:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }

        /**
        * マウスが移動するときのハンドラ。現在の線を更新
        *
        * @param event ステージが送出するイベント
        */
        private function onStageMouseMove(event:MouseEvent):void {
            drawLine();
            event.updateAfterEvent();
        }

        private function onStageMouseDoubleClick(event:MouseEvent):void{

        }

    }

}