/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nm1g
 */

// forked from 9re's flash on 2010-9-9
package {
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class WonderflAPITest extends Sprite {
        public function WonderflAPITest() {
            // write as3 code here..
            tf = new TextField;
            tf.wordWrap = true;
            tf.width = tf.height = 465;
            addChild(tf);
            
            var params:Object = loaderInfo.parameters || {
                open_api_key: "a76b80051993a7c6322bf8b4bbc457b44c3d4f5c", 
                key: "ABQIAAAAXpWFDG8Wm9YzscY4IEB27xSO5wqdqdHVqPB8sVJhBj86bhrVXRSBgqnsO9rxcctD5ppITaLzKCDqHA",
                appId: "fX4Z",
                "viewer.displayName": "bkzen",
                "viewer.iconURL": "http://wonderfl.net/images/icon/5/5c/5cda/5cda85d54f9fd460cfbe13de3b91e51e7442e136m",
                domain: "wonderfl.net"
            };
            
            var api:WonderflAPI = new WonderflAPI(params);
            
            testSuit(
                new ApiTest(api.apiCode(), APICodeData),
                new ApiTest(api.apiForks(), APIForksData),
                new ApiTest(api.apiUser(), APIUserData),
                new ApiTest(api.apiUserCodes(), APIUserCodesData),
                new Test(
                    testComplete
                )
            );
        }
        
        
        private function testSuit(...tests:Array):void {
            for (var i:int = 0; i < tests.length - 1; ++i) 
                tests[i].next = tests[i + 1];
                
            tests[0].exec();
        }
        
        private function testComplete():void
        {
            trace('------------------------------');
            trace('all tests passed. ok');
        }
        
    }
}
import flash.text.TextField;

var tf:TextField;
function trace(...o):void {
            tf.appendText(o + "\n");
            tf.scrollV = tf.maxScrollV;
        }

function assertAHasB(a:Object, b:Object):void {
            var value:*;
            for (var key:String in b) {
                value = a[key];
                if (typeof value == 'object') {
                    assertAHasB(value, b[key]);
                } else {
                    if (value != b[key]) throw new Error('doesnot match ' + key);
                    trace(key + ' matched');
                }
            }
        }


import com.adobe.serialization.json.JSON;
    import flash.events.Event;
import flash.net.*;

class Test {
    protected var _exec:Function;
    public function Test($exec:Function):void {
        _exec = $exec;
    }
    public function exec():void {
        _exec();
    }
    public var next:Test;
}

class ApiTest extends Test {
    public function ApiTest(url:String, resultClass:Class) {
        var ldr:URLLoader = new URLLoader;
        ldr.addEventListener(Event.COMPLETE, function _complete(e:*):void {
            ldr.removeEventListener(Event.COMPLETE, _complete);
            var rawData:Object = JSON.decode(ldr.data);
            assertAHasB(new resultClass(rawData), rawData);
            trace(resultClass + ' test ok');
            trace();
            
            if (next != null) next.exec();
        });
        super(function ():void {
            trace('------------------------------');
            trace('testing ' + resultClass);
            trace('loading data from ... ' + url);
            ldr.load(new URLRequest(url));
        });
    }
}


class WonderflAPIData
    {
        public static const STATE_OK: String = "ok";
        public static const STATE_FAIL: String = "fail";
        
        protected var _data: Object;
        
        public function WonderflAPIData(data: Object) 
        {
            this._data = data || {};
        }
        
        public function get stat(): String 
        {
            return _data.stat;
        }
        
        public function get isOK(): Boolean
        {
            return stat == STATE_OK;
        }
        
        public function get message(): String
        {
            return isOK ? "" : _data.message;
        }
        
    }

class SmallCodeData
    {
        protected var _createdDate: Date;
        protected var _data: Object;
        
        public function SmallCodeData(data: Object) 
        {
            this._data = data;
            _createdDate = new Date(created_date * 1000);
        }
        
        /**
         * コード ID(Application ID)
         */
        public function get id(): String { return _data.id; }
        
        /**
         * もしこのコードが何かをforkした作品だった場合はそのID
         */
        public function get parent(): String { return _data.parent; }
        
        /**
         * このコードが何かをフォークした作品かどうか
         */
        public function get isParent(): Boolean { return parent != null; }
        
        /**
         * コードのタイトル
         */
        public function get title(): String { return _data.title; }
        
        /**
         * コンパイルのステータス(1：コンパイル完了, 0:コンパイル未完了)
         */
        public function get compile_ok(): String { return _data.compile_ok; }
        
        /**
         * コンパイルできているかどうか
         */
        public function get compileOK(): Boolean { return compile_ok == "1"; }
        
        /**
         * 作成された日付(1970年1月1日0時(世界時)からの秒数)
         */
        public function get created_date(): int { return _data.created_date; }
        
        /**
         * 作成された日付
         */
        public function get createdDate(): Date { return _createdDate; }
        
        /**
         * ライセンス
         */
        public function get license(): String { return _data.license; }
        
        /**
         * フォークした場合などにフォーク元との差の行数
         */
        public function get diff(): int { return _data.diff; }
        
        /**
         * サムネイルのURL
         */
        public function get thumbnail(): String { return _data.thumbnail; }
        
        /**
         * SWFファイル の URL
         */
        public function get swf(): String { return _data.swf; }
        
    }
    
class SmallUserData
    {
        protected var _data: Object;
        
        public function SmallUserData(data: Object) 
        {
            this._data = data;
        }
        
        /**
         * ユーザーのアイコンURL
         */
        public function get icon(): String { return _data.icon; }
        
        /**
         * ユーザーの名前
         */
        public function get name(): String { return _data.name; }
        
    }

class UserData extends SmallUserData
    {
        
        public function UserData(data:Object) 
        {
            super(data);
        }
        
        /**
         * ユーザーのサイトURL
         */
        public function get external_url(): String { return _data.external_url; }
        
        /**
         * ユーザーの説明
         */
        public function get description(): String { return _data.description; }
        
    }

    
class ForkCodeData extends SmallCodeData
    {
        protected var _user: SmallUserData;
        
        public function ForkCodeData(data:Object) 
        {
            super(data);
            _user = new SmallUserData(data.user);
        }
        
        /**
         * ユーザーデータ
         */
        public function get user(): SmallUserData { return _user; }
        
    }    
    
 class CodeData extends ForkCodeData
    {
        protected var _modifiedDate: Date;
        
        public function CodeData(data:Object) 
        {
            super(data);
            _modifiedDate = new Date(modified_date * 1000);
        }
        
        /**
         * コードのスクリプト
         */
        public function get as3(): String { return _data.as3; }
        
        /**
         * 変更をした日付
         */
        public function get modifiedDate(): Date { return _modifiedDate; }
        
        /**
         * 変更をした日付(1970年1月1日0時(世界時)からの秒数)
         */
        public function get modified_date(): int { return _data.modified_date; }
        
        /**
         * フォークされた回数
         */
        public function get forked_count(): int { return _data.forked_count; }
        
        /**
         * favされた回数
         */
        public function get favorite_count(): int { return _data.favorite_count; }
        
    }   
    
    
    
class ScoreData
    {
        protected var _data: Object;
        
        public function ScoreData(data: Object) 
        {
            this._data = data;
        }
        
        /**
         * スコア
         */
        public function get score(): int { return _data.score; }
        
        /**
         * ユーザー名
         */
        public function get name(): String { return _data.name; }
    }

class APIUserData extends WonderflAPIData
    {
        protected var _user: UserData;
        
        public function APIUserData(data:Object) 
        {
            super(data);
            if (isOK)
            {
                _user = new UserData(_data.user);
            }
        }
        
        /**
         * ユーザーデータ API で取得したデータ(isOK == true の時のみ)
         */
        public function get user(): UserData { return _user; }
        
    }
    
class APIUserCodesData extends WonderflAPIData
    {
        protected var _length: int;
        protected var _codes: Vector.<SmallCodeData>;
        
        public function APIUserCodesData(data:Object) 
        {
            super(data);
            if (isOK)
            {
                _codes = new Vector.<SmallCodeData>();
                var arr: Array = _data.codes;
                _length = arr.length;
                for (var i: int = 0; i < _length; i++) 
                {
                    _codes[i] = new SmallCodeData(arr[i]);
                }
                _codes.fixed = true;
            }
        }
        
        /**
         * コードデータの個数
         */
        public function get length(): int { return _length; }
        
        /**
         * コードデータの配列
         */
        public function get codes(): Vector.<SmallCodeData> { return _codes; }
        
    }    


class APIScoreData extends WonderflAPIData
    {
        protected var _length: int;
        protected var _scores: Vector.<ScoreData>;
        
        public function APIScoreData(data: Object) 
        {
            super(data);
            if (isOK)
            {
                _scores = new Vector.<ScoreData>();
                var arr: Array = _data.scores;
                _length = arr.length;
                for (var i: int = 0; i < _length; i++) 
                {
                    _scores[i] = new ScoreData(arr[i]);
                }
                _scores.fixed = true;
            }
        }
        
        /**
         * ScoreData の個数
         */
        public function get length(): int { return _length; }
        
        /**
         * ScoreData の配列
         */
        public function get scores(): Vector.<ScoreData> { return _scores; }
        
    }
    
 class APIForksData extends WonderflAPIData
    {
        protected var _length: int;
        protected var _forks: Vector.<ForkCodeData>;
        
        public function APIForksData(data:Object) 
        {
            super(data);
            if (isOK)
            {
                _forks = new Vector.<ForkCodeData>();
                var arr: Array = _data.forks;
                _length = arr.length;
                for (var i: int = 0; i < _length; i++) 
                {
                    _forks[i] = new ForkCodeData(arr[i]);
                }
                _forks.fixed = true;
            }
        }
        
        /**
         * フォークされたコードデータの数
         */
        public function get length(): int { return _length; }
        
        /**
         * フォークされたコードデータの配列
         */
        public function get forks(): Vector.<ForkCodeData> { return _forks; }
        
        
    }    
    
 class APICodeData extends WonderflAPIData
    {
        protected var _code: CodeData;
        
        public function APICodeData(data:Object) 
        {
            super(data);
            if (isOK)
            {
                _code = new CodeData(_data.code);
            }
        }
        
        /**
         * コードデータ
         */
        public function get code(): CodeData { return _code; }
        
    }

class WonderflAPI
    {
        public static const CODE_URL: String       = "http://wonderfl.net/c/";
        public static const API_URL: String        = "http://api.wonderfl.net/";
        public static const API_CODE: String       = API_URL + "code/%ID%?api_key=%API_KEY%";
        public static const API_USER: String       = API_URL + "user/%NAME%?api_key=%API_KEY%";
        public static const API_FORKS: String      = API_URL + "code/%ID%/forks?api_key=%API_KEY%";
        public static const API_SCORE_GET: String  = API_URL + "score/%ID%?api_key=%API_KEY%&descend=%DESC%&limit=%LIMIT%";
        public static const API_SCORE_SET: String  = API_URL + "score/%ID%";
        public static const API_USER_CODES: String = API_URL + "user/%NAME%/codes?api_key=%API_KEY%";
        
        private var _apiCode: String;
        private var _apiUser: String;
        private var _apiForks: String;
        private var _apiScoreGet: String;
        private var _apiScoreSet: String;
        private var _apiUserCodes: String;
        
        private var _key: String;
        private var _appID: String;
        private var _domain: String;
        private var _openAPIKey: String;
        private var _viewerIconURL: String;
        private var _viewerDisplayName: String;
        
        /**
         * Wonderfl API を使用するためのライブラリ
         * コンストラクタ
         * @param    params : FlashVars を指定 (loaderInfo.parameters)
         * @param    apiKey : Open API Key を使用しない場合に使用する。
         */
        public function WonderflAPI(params: Object, apiKey: String = null) 
        {
            _key               = params["key"];
            _appID             = params["appId"];
            _domain            = params["domain"];
            _openAPIKey        = apiKey || params["open_api_key"];
            _viewerIconURL     = params["viewer.iconURL"];
            _viewerDisplayName = params["viewer.displayName"];
            
            //
            _apiCode      = API_CODE.replace(/%API_KEY%/, _openAPIKey);
            _apiUser      = API_USER.replace(/%API_KEY%/, _openAPIKey);
            _apiForks     = API_FORKS.replace(/%API_KEY%/, _openAPIKey);
            _apiScoreGet  = API_SCORE_GET.replace(/%API_KEY%/, _openAPIKey);
            _apiScoreSet  = API_SCORE_SET.replace(/%API_KEY%/, _openAPIKey);
            _apiUserCodes = API_USER_CODES.replace(/%API_KEY%/, _openAPIKey);
            
        }
        
        /**
         * URL から Application ID を取得
         * @param    url : 現在のコードのURL
         * @return    
         */
        public function getAppID(url: String): String
        {
            return url.replace(CODE_URL, "");
        }
        
        /**
         * Code API の URL を取得
         * @param    appID :　Code API に指定する Application ID. 指定しなかった場合はコンストラクタで指定したオブジェクトの appId が使用される。
         * @return
         */
        public function apiCode(appID: String = null): String
        {
            return _apiCode.replace(/%ID%/, appID || _appID);
        }
        
        /**
         * User API の URL を取得
         * @param    user : User API に指定する UserName. 指定しなかった場合はコンストラクタで指定したオブジェクトの viewer.displayName が使用される。
         * @return
         */
        public function apiUser(user: String = null): String
        {
            return _apiUser.replace(/%NAME%/, user || _viewerDisplayName);
        }
        
        /**
         * Forks Code API の URL を取得
         * @param    appID : Forks Code API に指定する Application ID. 指定しなかった場合はコンストラクタで指定したオブジェクトの appId が使用される。
         * @return
         */
        public function apiForks(appID: String = null): String
        {
            return _apiForks.replace(/%ID%/, appID || _appID);
        }
        
        /**
         * Score API (get) の URL を取得
         * @param    limit    : スコアの取得数 (1 - 99)
         * @param    descend    : 1:降順で取得、 0: 昇順で取得
         * @param    appID    : Score API (get) に指定する Application ID. 指定しなかった場合はコンストラクタで指定したオブジェクトの appId が使用される。
         * @return
         */
        public function apiScoreGet(limit: uint = 20, descend: uint = 1, appID: String = null): String
        {
            return _apiScoreGet.replace(/%ID%/, appID || _appID).replace(
                /%DESC%/,  descend > 1 ? 1 : descend).replace(/%LIMIT%/, limit > 99 ? 99 : (limit || 1));
        }
        
        /**
         * Score API (set) の URL を取得
         * @param    appID    : Score API (set) に指定する Application ID. 指定しなかった場合はコンストラクタで指定したオブジェクトの appId が使用される。
         * @return
         */
        public function apiScoreSet(appID: String = null): String
        {
            return _apiScoreSet.replace(/%ID%/, appID || _appID);
        }
        
        /**
         * Score API (set) の Post データを取得
         * @param    score    : スコア
         * @param    name    : ユーザー名。指定しなかった場合はコンストラクタで指定した viewer.displayName が使用される。
         * @return
         */
        public function apiScorePostObject(score: int, name: String = null): Object
        {
            return { "api_key": _openAPIKey, "name": name, "score": (score || _viewerDisplayName) };
        }
        
        /**
         * User Codes API の URL を取得
         * @param    name    : ユーザー名。指定しなかった場合はコンストラクタで指定した viewer.displayName が使用される。
         * @return
         */
        public function apiUserCodes(name: String = null): String
        {
            return _apiUserCodes.replace(/%NAME%/, name || _viewerDisplayName);
        }
        
        
        
        public function get key(): String { return _key; }
        
        public function get appID(): String { return _appID; }
        
        public function get domain(): String { return _domain; }
        
        public function get openAPIKey(): String { return _openAPIKey; }
        
        public function get viewerIconURL(): String { return _viewerIconURL; }
        
        public function get viewerDisplayName(): String { return _viewerDisplayName; }
        
    }
