/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nkjc
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.ShaderJob;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.ShaderEvent;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	import flash.utils.setTimeout;
	import org.libspark.betweenas3.BetweenAS3;
	/**
	 * @author kobayashi-taro @ kayac inc.
	 */
	public class Mandelbrot extends Sprite
	{
		
		private const WONDERFL:int = 465;
		private var _job:ShaderJob;
		private var _bd:BitmapData;
		private var _timer:int;
		private var _kernel:MandelbrotRenderingKernel;
		private var _images:Array;
		private var _buffers:Array;
		private var _lock:Boolean;
		private var _bufferIndex:int = 0;
		private var _basePoint:Point = new Point(-2.5, -2);
		private var _rectLength:Number = 4.0;
		private var _benchInfo:TextField;
		private var _imageLayer:Sprite;
		
		public function Mandelbrot() 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(MouseEvent.MOUSE_WHEEL, onMouseWheel);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			stage.addEventListener(Event.MOUSE_LEAVE, onMouseLeave);
			
			addChild(_imageLayer = new Sprite);
			addChild(_benchInfo = new TextField);
			
			_benchInfo.defaultTextFormat = new TextFormat("_sans", 12, 0xffffff);
			_benchInfo.mouseEnabled = _benchInfo.mouseWheelEnabled = _benchInfo.selectable = false;
			_benchInfo.background = true;
			_benchInfo.backgroundColor = 0;
			
			buttonMode = true;
			tabEnabled = false;
			
			_images = [];
			_buffers = [];
			
			var image:Image;
			var bd:BitmapData;
			for (var i:int = 0; i < 2; ++i) {
				_images.push(image = new Image);
				_buffers.push(bd = new BitmapData(WONDERFL, WONDERFL));
				image.bitmapData = bd;
			}
			
			var spMask:Sprite = new Sprite;
			spMask.graphics.beginFill(0);
			spMask.graphics.drawRect(0, 0, WONDERFL, WONDERFL);
			spMask.graphics.endFill();
			mask = spMask;
			
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			_bd = new BitmapData(WONDERFL, WONDERFL);
			_kernel = new MandelbrotRenderingKernel;
			
			doJob();
		}
		
		private function onJobComplete($event:ShaderEvent):void 
		{
			_job.removeEventListener(ShaderEvent.COMPLETE, onJobComplete);
			_job = null;
			
			var t:Number = getTimer() - _timer;
			_benchInfo.text = "rendering time: " + t + " ms";
			_benchInfo.width = _benchInfo.textWidth + 4;
			_benchInfo.height = _benchInfo.textHeight + 4;
			
			_lock = false;
			var image:Image;
			_bufferIndex = 1 - _bufferIndex;
			image = getCurrentImage();
			image.x = 0;
			image.y = 0;
			image.scaleX = image.scaleY = 1;
			image.alpha = 0;
			BetweenAS3.to(image, { alpha:1 }, 0.25).play();
			setTimeout(clearBackBuffer, 250);
			image.bitmapData = _bd;
			_imageLayer.addChild(image);
		}
		
		private function clearBackBuffer():void
		{
			_images[1 - _bufferIndex].alpha = 0;
		}
		
		private function doJob():void {
			if (_lock) return;
			
			var image:Image = getCurrentImage();
			_basePoint.x += -image.x * _rectLength / WONDERFL;
			_basePoint.y += -image.y * _rectLength / WONDERFL;
			
			var scale:Number = WONDERFL / _rectLength;
			
			if (_kernel.baseX == _basePoint.x && _kernel.baseY == _basePoint.y && _kernel.scale == scale)
				return;
			
			image.alpha = 0;
			_kernel.basePoint = _basePoint;
			_kernel.scale = scale;
			
			_job = new ShaderJob;
			_job.shader = _kernel;
			_job.width = WONDERFL;
			_job.height = WONDERFL;
			_job.target = _bd;
			_job.addEventListener(ShaderEvent.COMPLETE, onJobComplete);

			//image.visible = false;

			_lock = true;
			_timer = getTimer();
			_job.start();
		}
		
		private function onMouseWheel(e:MouseEvent):void 
		{
			if (_lock) return;
			
			var oldLength:Number = _rectLength;
			var scale:Number = (e.delta > 0) ? 0.625 : 1.6;
			_rectLength *= scale;
			scale = (oldLength - _rectLength) / WONDERFL;
			
			var image:Image = getCurrentImage();
			image.alpha = 0;
			
			_basePoint.x += scale * mouseX;
			_basePoint.y += scale * mouseY;
			
			doJob();
		}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			getCurrentImage().startDrag();
		}
		
		private function onMouseUp(e:MouseEvent):void 
		{
			stopDragging();
		}
		
		private function onMouseLeave(e:Event):void 
		{
			stopDragging();
		}
		
		private function stopDragging():void {
			getCurrentImage().stopDrag();
			doJob();
		}
		
		private function getCurrentImage():Image {
			return _images[_bufferIndex];
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shader;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import flash.utils.ByteArray;
import mx.utils.Base64Decoder;
import mx.utils.Base64Encoder;

class MandelbrotRenderingKernel extends Shader {
	//[Embed(source="../assets/MandelBrot.pbj", mimeType="application/octet-stream")]
	//private var _kernelByteCode:Class;
	private var _baseX:Number;
	private var _baseY:Number;
	private var _scale:Number;
	
	public function MandelbrotRenderingKernel() {
		var decoder:Base64Decoder = new Base64Decoder;
		decoder.decode(<mandelbrotKernel>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</mandelbrotKernel>);
		super(decoder.drain().readObject());
	}
	
	public function set basePoint(value:Point):void {
		data.basePoint.value[0] = value.x;
		data.basePoint.value[1] = value.y;
		_baseX = value.x;
		_baseY = value.y;
	}
	
	
	public function set scale(value:Number):void 
	{
		_scale = value;
		data.scale.value[0] = value;
	}
	public function get scale():Number { return _scale; }
	
	public function get baseX():Number { return _baseX; }
	
	public function get baseY():Number { return _baseY; }
}

class Image extends Sprite {
	private var _bitmap:Bitmap;
	
	public function Image() {
		addChild(_bitmap = new Bitmap);
	}
	
	public function get bitmapData():BitmapData {
		return _bitmap.bitmapData;
	}
	
	public function set bitmapData(value:BitmapData):void {
		_bitmap.bitmapData = value;
	}
}
