/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nkXu
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ConvolutionFilter;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author gaina
     */
    [SWF(width = 465, height = 465, backgroundColor = 0)]
    public class Main extends Sprite 
    {
        private var _canvas:BitmapData;
        private var _convo:ConvolutionFilter;
        private var _r:Array;
        private var _g:Array;
        private var _b:Array;
        private var _sound:Sound;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            Security.allowDomain("*");
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, SoundLoaded);
            _sound.load(new URLRequest("http://www.takasumi-nagai.com/soundfiles/sound006.mp3"), new SoundLoaderContext(1000, true));
            
            _canvas = new BitmapData(465, 465, false, 0);
            var _matrix:Array = [
                                1, 2, 1, 
                                2, 5, 2, 
                                1, 2, 1
                                ];
            _convo = new ConvolutionFilter(3, 3, _matrix, 0xFF, 0, true, true);
            
            addChild(new Bitmap(_canvas));
            
            _r = [0, 0, 0, 0xFF0000, 0, 0, 0, 0, 0, 0, 0x0000FF, 0, 0x00FF00];
            _g = [0, 0, 0, 0x00FF00, 0, 0, 0, 0, 0, 0, 0xFF0000, 0, 0x0000FF];
            _b = [0, 0, 0, 0x0000FF, 0, 0, 0, 0, 0, 0, 0x00FF00, 0, 0xFF0000];
            
            _canvas.noise(Math.random() * 0x100);
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function SoundLoaded(e:Event):void 
        {
            _sound.play(0, 100, new SoundTransform(0.3, 0));
        }
        
        private function loop(e:Event):void 
        {
            var _bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytes, true);
            var p:Number = 0;
            
            for (var i:int = 0; i < 512; i++) {
                p += _bytes.readFloat();
            }
            
            
            _canvas.lock();
            if (p > 22) {
                change();
            }
            _canvas.applyFilter(_canvas, _canvas.rect, _canvas.rect.topLeft, _convo);
            _canvas.paletteMap(_canvas, _canvas.rect, _canvas.rect.topLeft, _r, _g, _b, null);
            _canvas.unlock();
        }
        
        private var _count:int = 0;
        private function change():void
        {
            _count %= 3;
            switch(_count)
            {
                case 0:
                _canvas.noise(Math.random() * 0x100);
                _r = [0, 0, 0, 0xFF0000];
                _g = [0, 0, 0, 0x00FF00];
                _b = [0, 0, 0, 0x0000FF];
                _convo.matrix = [
                                1, 2, 1, 
                                2, 5, 2, 
                                1, 2, 1
                                ];
                break;
                case 1:
                _canvas.noise(Math.random() * 0x100);
                _r = [0, 0, 0xFF0000];
                _g = [0, 0, 0x00FF00];
                _b = [0, 0, 0x0000FF];
                _convo.matrix = [
                                2, 1, 2, 
                                1, 8, 1, 
                                2, 1, 2
                                ];
                break;
                case 2:
                _canvas.noise(Math.random() * 0x100);
                _r = [0, 0, 0, 0xFF0000, 0, 0, 0, 0, 0, 0, 0, 0xFF0000, 0xFF0000];
                _g = [0, 0, 0, 0x00FF00, 0, 0, 0, 0, 0, 0, 0, 0x00FF00, 0x00FF00];
                _b = [0, 0, 0, 0x0000FF, 0, 0, 0, 0, 0, 0, 0, 0x0000FF, 0x0000FF];
                _convo.matrix = [
                                1, 1, 1, 
                                1, 9, 1, 
                                1, 1, 1
                                ];
                break;
                default:
                _count = 0;
                break;
            }
            _count++;
        }
    }
    
}