/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nk8R
 */

// forked from zonnbe's Flying Text
package  {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldType;
    
    [SWF(width=465,height=465,backgroundColor="0xffffff",frameRate=90)]
    public class flytext extends Sprite {

//////////////////////////////////////////////////////////////////////////////////
///////  EDIT by BradSedito  //  BEGIN  ////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

    private var variableOffset:Number;
    private var mX          =   mouseX;
    private var mY          =   mouseY;
    private var mZ_Pos:Number   =   (stage.stageHeight/2) + (mouseY/2);
    private var mZ_Neg:Number   =   (stage.stageHeight/2) - (mouseY/2);

//////////////////////////////////////////////////////////////////////////////
///////  EDIT by BradSedito  //  END    ///////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

        private var bmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
        private var bmp:Bitmap = new Bitmap(bmpd);
        
        private var textBmpd:BitmapData;
        
        private var gridSizeW:int = 2.5;
        private var gridSizeH:int = 2.5;
        private var blockSizeW:int = 2;
        private var blockSizeH:int = 2;
//        private var offsetW:int = gridSizeW/2 - blockSizeW/2;
//        private var offsetH:int = gridSizeH/2 - blockSizeH/2;
        private var offsetW:int = 6;
        private var offsetH:int = 6;

        private var counter:int = 0;
        private var txt:TextField;
        private var etxt:TextField;
        private var txtpx:int = 0;
        
        private var msx:Number = 0;
        private var mouseDrag:Boolean = false;
        
        private var ct:ColorTransform =  new ColorTransform(1,1,1,0.6);
        
        private var dot:MovieClip = new MovieClip();
        private var cuint:uint = 0xFF2E363F;
        
        private var scale:Number = 0.6;
        private var mgsw:int = int(Math.round(gridSizeW * scale));
        private var mgsh:int = int(Math.round(gridSizeH * scale));
        private var mbsw:int = int(Math.round(blockSizeW * scale));
        private var mbsh:int = int(Math.round(blockSizeH * scale));
        private var mosw:int = mgsw/2 - mbsw/2;
        private var mosh:int = mgsh/2 - mbsh/2;
        private var mbosx:int = 30;
        private var mbosy:int = 60;
        
        private var D2R:Number = Math.PI/180;
        private var textBmpdW:Number = 650;

        public function flytext() {
            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF)));
            addChild(bmp);
            bmpd.fillRect(bmpd.rect, 0x0);
            
            textBmpd = new BitmapData(textBmpdW, 200);
            
            var TF:TextFormat = new TextFormat();
            TF.color = 0x000000;
            TF.font = "Arial";
            TF.size = 140;
            
            txt = new TextField();
            txt.defaultTextFormat = TF;
            txt.autoSize = "left";
            txt.selectable=false;
            
            var ETF:TextFormat = new TextFormat();
            ETF.color = 0x000000;
            ETF.font = "Arial";
            ETF.size = 14;
            
            etxt = new TextField();
            etxt.defaultTextFormat = ETF;
            etxt.autoSize = "left";
            etxt.selectable = true;
            etxt.type = TextFieldType.INPUT;
            etxt.text = "You stay classy, Wonderfl.";
            etxt.border = true;
            etxt.borderColor = 0xffffff;
            etxt.y = stage.stageHeight - 20;
            etxt.addEventListener(Event.CHANGE, textUpdate);
            
            addChild(etxt);
            stage.focus = etxt;
            
            txt.text = etxt.text;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onmouseUp);
            stage.addEventListener(Event.ENTER_FRAME, processing);
        }
        
        public function textUpdate(e:Event):void
        {
            txt.text = etxt.text;
        }
        
        public function onmouseDown(e:MouseEvent):void
        {
            mouseDrag = true;
            msx = mouseX;
        }
        
        public function onmouseUp(e:MouseEvent):void
        {
            mouseDrag = false;
        }
        
        public function processing(e:Event):void
        {
            update();
            paint();
        }
        
        public function update():void
        {
            textBmpd.lock();
            textBmpd.fillRect(textBmpd.rect, 0xFFFFFFFF);
            if(!mouseDrag)
                txtpx -= gridSizeW;
            else {
                var dragStrength:int = Math.round((mouseX - msx) / gridSizeW);
                txtpx += dragStrength * 8;
                msx = mouseX;
                
                
            }
            var matrix:Matrix = new Matrix();
            matrix.translate(txtpx, 0);
            textBmpd.draw(txt, matrix);
            var matrix2:Matrix = new Matrix();
            matrix2.translate(txtpx - txt.width, 0);
            textBmpd.draw(txt, matrix2);
            if(txtpx - txt.width > 0)
                txtpx = 0;
            if(txtpx + txt.width <= textBmpdW)
                txtpx = textBmpdW;
            textBmpd.unlock();
        }
        
        public function paint():void
        {
            var ow:int = textBmpd.width;
            var oh:int = textBmpd.height;
            
            var i:int = 0;
            var j:int = 0;
            var bx:int = 0;
            var by:int = 0;
            var tuint:uint = 0;
            
            bmpd.lock();
            bmpd.colorTransform(bmpd.rect, ct);
            
            for(i = 0; i < ow/gridSizeW; i++)
            {
                for(j = 0; j < oh/gridSizeH; j++)
                {
                    tuint = textBmpd.getPixel32(i * gridSizeW, j * gridSizeH);
                    if(tuint != 0xFFFFFFFF)
                    {
                        bmpd.fillRect(new Rectangle(i * mgsw + mosw + mbosx + j, 20 * Math.sin((i * mgsw + mosw + mbosx + counter) * D2R) + j * mgsh + mosh + mbosy, mbsw, mbsh), 0xFFCC3333);
                        bmpd.fillRect(new Rectangle(i * mgsw + mosw + mbosx + j, 20 * Math.sin((i * mgsw + mosw + mbosx + counter) * D2R) + 25 * Math.cos((i * mgsw + mosw + mbosx + j * 360/(30) + counter) * D2R) + mosh + mbosy + 75 + 75/2, mbsw, mbsh), 0x00000000);
                        bmpd.fillRect(new Rectangle(i * mgsw + mosw + mbosx + j, 10 * Math.sin((i * 3 * mgsw + mosw + mbosx + j * 360/(20) + counter) * D2R) + j * mgsh + mosh + mbosy + 150, mbsw, mbsh), 0x00000000);
                        bmpd.fillRect(new Rectangle(i * mgsw + mosw + mbosx    , j * mgsh + mosh + mbosy + 225, mbsw, mbsh), cuint);
                    }
                }
            }
            bmpd.unlock();
            if(counter++>360) counter = 0;
        }
    }
    
}
