/**
 * Copyright kuma360 ( http://wonderfl.net/user/kuma360 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/njpl
 */

//右上が元画像
//右下がフィルター
//左下が引数
//左上が結果

package 
{
    import com.bit101.components.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    
    public class Main extends Sprite 
    {
        public function Main() { init() ; }
        
        //キャンバス
        private var _screen:BitmapData ;
        
        //画像用
        private var _img:BitmapData ;
        
        //GUI用
        private var _gui:GUI ;
        
        //フィルタ用
        private var _fil:BitmapData ;
        
        public function init () :void {
            
            /////////////////////////////////////////////////////
            //キャンバス用意
            _screen = new BitmapData ( 465 , 465 , false , 0 ) ;
            addChild ( new Bitmap ( _screen ) ) ;
            
            
            /////////////////////////////////////////////////////
            //リソース用意
            _fil  = new BitmapData ( 200 , 200 , false , 0 ) ;
            _img = new BitmapData ( 200 , 200 , false , 0 ) ;
            
            _gui = new GUI ;
            addChild ( _gui ) ;
            
            
            //////////////////////////////////////////////////////
            //フィルター用意
            var T:Sprite = new Sprite ();
            var G:Graphics = T.graphics ;
            
            //黒
            G.beginFill ( 0x000000 ) ; G.drawRect ( 100 , 0 , 200 , 200 ) ; G.endFill () ;
            
            //赤-線形グラデーション
            var M:Matrix = new Matrix ;
            M.createGradientBox ( 50 , 200 ) ;
            G.beginGradientFill ( "linear" , [ 0xFF0000 , 0x000000 ] , [ 1 , 1 ] , [ 0 , 255 ] , M ) ;
            G.drawRect ( 0, 100, 50, 100 ) ;
            G.endFill ( ) ;
            
            //緑-円形グラデーション
            M.createGradientBox ( 100 , 100 ) ;
            G.beginGradientFill ( "radial" , [ 0x00FF00 , 0x000000 ] , [ 1 , 1 ] , [ 0 , 255 ] , M ) ;
            G.drawRect ( 0, 0, 100, 100 ) ;
            G.endFill ( ) ;
            
            //青色のグラデーション（厚め)
            G.beginFill ( 0x000040 ) ; G.drawRect ( 100 ,   0 , 100 , 66 ) ; G.endFill () ;
            G.beginFill ( 0x000080 ) ; G.drawRect ( 100 ,  66 , 100 , 66 ) ; G.endFill () ;
            G.beginFill ( 0x0000C0 ) ; G.drawRect ( 100 , 132 , 100 , 66 ) ; G.endFill () ;
            
            _fil.draw ( T ) ;
            
            
            /////////////////////////////////////////////////////
            //画像ロード
            var L:Loader = new Loader ;
            L.contentLoaderInfo.addEventListener (
                Event.COMPLETE ,
                function ( e:Event ):void {
                    
                    _img.draw ( L ) ;
                    
                    addEventListener ( Event.ENTER_FRAME , run ) ;
                    
                }
            ) ;
            
            L.load ( 
                new URLRequest ( "http://assets.wonderfl.net/images/related_images/a/a1/a10d/a10d6c78360eabfb12f062b34e5840f8c4a560a5m" ) ,
                new LoaderContext ( true )
            ) ;
            
        }
        
        
        public function run ( e:Event ):void {
            
            //////////////////////////////////////////////////////
            _screen.copyPixels ( _img, _img.rect, new Point ( 0, 0 ) ) ;
            _screen.copyPixels ( _img, _img.rect, new Point ( 265, 0 ) ) ;
            _screen.copyPixels ( _fil, _fil.rect, new Point ( 265, 200 ) ) ;
            _screen.fillRect ( new Rectangle ( 0 , 200 , 200 , 200 ) , 0xFFFFFF ) ;
            
            //////////////////////////////////////////////////////
            var D:DisplacementMapFilter = new DisplacementMapFilter ( 
                _fil , 
                new Point ( 
                    _gui.myHUISlider5.value , 
                    _gui.myHUISlider6.value  
                ) , 
                _gui.myHUISlider1.value , 
                _gui.myHUISlider2.value , 
                _gui.myHUISlider3.value , 
                _gui.myHUISlider4.value , 
                "wrap" , 
                0, 
                1 
            );
            
            _screen.applyFilter ( _img, _img.rect, new Point , D ) ;
            
        }
        
    }
    
}




import com.bit101.components.*;
import flash.display.Sprite;

class GUI extends Sprite
{
    public  var myHUISlider1:HUISlider;
    public  var myHUISlider2:HUISlider;
    public  var myHUISlider3:HUISlider;
    public  var myHUISlider4:HUISlider;
    public  var myHUISlider5:HUISlider;
    public  var myHUISlider6:HUISlider;

    public function GUI()
    {
        myHUISlider5 = new HUISlider ( this, 0, 200,  "posX" ) ;
        myHUISlider5.maximum = 100 ;
        myHUISlider5.minimum = - 100 ;
        myHUISlider5.value = 0 ;

        myHUISlider6 = new HUISlider ( this, 0, 220,  "posY" ) ;
        myHUISlider6.maximum = 100 ;
        myHUISlider6.minimum = - 100 ;
        myHUISlider6.value = 0 ;
        
        myHUISlider1 = new HUISlider ( this, 0, 240,  "compX" ) ;
        myHUISlider1.maximum = 8 ;
        myHUISlider1.value = 2 ;

        myHUISlider2 = new HUISlider ( this, 0, 260,  "compY" ) ;
        myHUISlider2.maximum = 8 ;
        myHUISlider2.value = 4 ;

        myHUISlider3 = new HUISlider ( this, 0, 280,  "scaleX" ) ;
        myHUISlider3.maximum = 200 ;
        myHUISlider3.minimum = - 200 ;
        myHUISlider3.value = 100 ;

        myHUISlider4 = new HUISlider ( this, 0, 300, "scaleY" ) ;
        myHUISlider4.maximum = 200 ;
        myHUISlider4.minimum = - 200 ;
        myHUISlider4.value = 100 ;

    }    
}

