/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/njlu
 */

// 
// 入力遅延がどれくらい影響を及ぼすのかについてのテスト。
// 
// 矢印キーで移動します。
// スペースキーでA, Bが切り替わります。
//
// A, Bのどちらかが入力に遅延のあるモードで、
// 右下のボタンでどちらに遅延があるか解答します。
// 
// 正解だとdelay time（遅延時間）が減少、
// 不正解だと増加します。
// 
// なお、画面上から降ってくる円はダミーで意味はありません。
// 
package
{
	import flash.display.SimpleButton;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	import net.hires.debug.Stats;
	[SWF(frameRate = 60)]
    public class FlashTest extends Sprite
	{
		private const SW:Number = stage.stageWidth;
		private const SH:Number = stage.stageHeight;
		
		private var tfOutput:TextField;
		
		private var player:Sprite;
		private var spBullet:Sprite;
		private var bullets:/*Sprite*/Array;
		
		private var delayNum:int;
		private var isDelay:Boolean;
		private var delayType:Boolean;
		private var input:Array;
		private var downKeys:Array;
		private var inputnow:Boolean = false;
        public function FlashTest()
		{
			var s:Stats = new Stats();
			stage.addChild(s);
			s.x = SW - 70;
			
			graphics.beginFill(0);
			graphics.drawRect(0, 0, SW, SH);
			graphics.endFill();
			
			tfOutput = new TextField();
			tfOutput.autoSize = "left";
			tfOutput.defaultTextFormat = new TextFormat(null, 24, 0xFFFFFF);
			addChild(tfOutput);
			
			player = new Sprite();
			player.x = SW * .5;
			player.y = SH * .75;
			stage.addChild(player);
			player.graphics.beginFill(0xFF0000);
			player.graphics.drawCircle(0, 0, 2);
			bullets = new Array();
			
			input = new Array();
			downKeys = new Array();
			delayNum = 10;
			for (var i:int = 0; i < delayNum; i++)
			{
				input[i] = null;
			}
			isDelay = Math.random() < .5 ? true : false;
			delayType = true;
			tfOutput.text = "delay time : " + delayNum + "\n";
			tfOutput.appendText(delayType ? "A" : "B");
            
			spBullet = new Sprite();
			spBullet.graphics.beginFill(0xC0C0C0);
			spBullet.graphics.drawCircle(0, 0, 20);
			spBullet.graphics.endFill();
			
			stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
			
			var sp:Sprite = new Sprite();
			sp.graphics.beginFill(0xE0E0E0);
			sp.graphics.drawRect(0, 0, 40, 40);
			var tf:TextField = new TextField();
			tf.text = "A";
			sp.addChild(tf);
			tf.x = tf.y = 10;
			var btnA:SimpleButton = new SimpleButton(sp, sp, sp, sp);
			stage.addChild(btnA);
			btnA.x = SW - 100;
			btnA.y = SH - 40;
			btnA.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void
			{
				if (delayType == isDelay)
				{
					delayNum--;
					if (delayNum < 0) delayNum = 1;
				}
				else
				{
					delayNum++;
				}
				delayUpdate();
			});
			
			sp = new Sprite();
			sp.graphics.beginFill(0xE0E0E0);
			sp.graphics.drawRect(0, 0, 40, 40);
			tf = new TextField();
			tf.text = "B";
			sp.addChild(tf);
			tf.x = tf.y = 10;
			var btnB:SimpleButton = new SimpleButton(sp, sp, sp, sp);
			stage.addChild(btnB);
			btnB.x = SW - 40;
			btnB.y = SH - 40;
			btnB.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void
			{
				if (delayType != isDelay)
				{
					delayNum--;
					if (delayNum < 0) delayNum = 1;
				}
				else
				{
					delayNum++;
				}
				delayUpdate();
			});
        }
		private function delayUpdate():void
		{
			isDelay = Math.random() < .5 ? true : false;
			delayType = true;
			tfOutput.text = "delay time : " + delayNum + "\n";
			tfOutput.appendText(delayType ? "A" : "B");
			for (var i:int = 0; i < delayNum; i++)
			{
				input[i] = null;
			}
		}
		
		private var movespeed:Number = 3;
		private function enterFrameHandler(e:Event):void
		{
			// update
			if (inputnow)
			{
				if (isDelay)
					input[delayNum] = downKeys.concat();
				else
					input[0] = downKeys;
			}
			else
			{
				input[delayNum] = null;
			}
			var inputKey:* = input.shift();
			if (inputKey != null)
			{
				if (inputKey[37])
				{
					player.x -= movespeed;
				}
				else if (inputKey[39])
				{
					player.x += movespeed;
				}
				if (inputKey[38])
				{
					player.y -= movespeed;
				}
				else if (inputKey[40])
				{
					player.y += movespeed;
				}
			}
			
			if (Math.random() < .1)
			{
				var sp:Sprite = new Sprite();
				sp.graphics.copyFrom(spBullet.graphics);
				addChild(sp);
				bullets.push(sp);
				sp.x = Math.random() * SW;
			}
			for (var i:int = 0; i < bullets.length; i++)
			{
				var b:Sprite = bullets[i];
				b.y += movespeed;
				if (b.y > SH+20)
				{
					bullets.splice(i--, 1);
					removeChild(b);
				}
			}
		}
		
		private function keyDownHandler(e:KeyboardEvent):void
		{
			if (e.keyCode == 32)
			{
				isDelay = !isDelay;
				delayType = !delayType;
				tfOutput.text = "delay time : " + delayNum + "\n";
				tfOutput.appendText(delayType ? "A" : "B");
			}
			downKeys[e.keyCode] = true;
			inputnow = true;
		}
		
		private function keyUpHandler(e:KeyboardEvent):void 
		{
			downKeys[e.keyCode] = false;
			inputnow = true;
		}
		
    }
}