/**
 * Copyright seyself ( http://wonderfl.net/user/seyself )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/njX2
 */

package 
{
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.AsyncErrorEvent;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.NetStatusEvent;
    import flash.events.SecurityErrorEvent;
    import flash.events.StatusEvent;
    import flash.external.ExternalInterface;
    import flash.media.Camera;
    import flash.media.Microphone;
    import flash.net.GroupSpecifier;
    import flash.net.NetConnection;
    import flash.net.NetGroup;
    import flash.net.NetStream;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    
    /**
     * ...
     * @author seyself
     */
    public class Main extends Sprite 
    {
        private var _connection:PearAssistConnection;
        private var _inputUserName:TextField;
        private var _connectButton:DisplayObject;
        private var _postButton:DisplayObject;
        private var _userName:String;
        private var _inputMessage:TextField;
        private var _outputBox:TextField;
        private var _loginLabel:TextField;
        private var _inputLabel:TextField;
        
        public function Main():void 
        {
            stage.align = 'LT';
            stage.scaleMode = 'noScale';
            
            init();
        }
        
        private function init():void 
        {
            _loginLabel = createTextField('input login name.', this, 5, 5, 0, 0, 0xffffff, 0xffffff, false, false, 1);
            _inputUserName = createTextField('', this, 5, 25, 120, 20, 0xffffff, 0x000000, false, false, 2);
            _connectButton = createButton('connect >>', this, 130, 25, entry);
            
            _inputLabel = createTextField('input message.', this, 5, 5, 0, 0, 0xffffff, 0xffffff, false, false, 1);
            _inputMessage = createTextField('', this, 5, 25, 360, 60, 0xffffff, 0x000000, true, false, 2);
            _postButton = createButton('>> post', this, 5, 90, post);
            
            _outputBox = createTextField('', this, 5, 120, 360, 300, 0xffffff, 0x000000, true, false, 1);
            
            _inputLabel.visible = false;
            _outputBox.visible = false;
            _inputMessage.visible = false;
            _postButton.visible = false;
            
            
        }
        
        private function createButton(label:String, con:Sprite, x:Number, y:Number, onClick:Function):DisplayObject
        {
            var t:TextField = createTextField(' '+label+' ', con, x, y, 0, 0, 0xefefef, 0x666666, false, true, 1);
                t.selectable = false;
                t.addEventListener('click', function(event:Event):void
                {
                    onClick();
                });
            con.addChild(t);
            return t;
        }
        
        private function createTextField(label:String, con:Sprite, x:Number, y:Number, w:Number, h:Number,
            bg:uint, border:uint, multiline:Boolean = false, autoSize:Boolean = false, type:int=2):TextField
        {
            var t:TextField = new TextField();
                if (w) t.width = w;
                if (h) t.height = h;
                t.x = x;
                t.y = y;
                t.background = true;
                t.backgroundColor = bg;
                t.border = true;
                t.borderColor = border;
                if (multiline)
                {
                    t.multiline = true;
                    t.wordWrap = true;
                }
                else
                {
                    t.autoSize = autoSize ? 'left' : 'none';
                    t.multiline = false;
                    t.wordWrap = false;
                }
                t.text = label;
                t.type = type == 2 ? 'input' : 'dynamic';
            addChild(t);
            return t;
        }
        
        private function entry():void
        {
            _userName = _inputUserName.text;
            connect();
        }
        
        private function connect():void
        {
            if (!_userName) return;
            
            _connection = new PearAssistConnection();
            _connection.onConnect = onConnect;
            _connection.onGroup = onGroup;
            _connection.onPosting = onPosting;
            _connection.doConnect();
            
            removeChild(_loginLabel);
            removeChild(_inputUserName);
            removeChild(_connectButton);
        }
        
        private function onPosting(message:Object):void
        {
            _outputBox.appendText(message.user + ' : ' + message.text + '\n');
        }
        
        private function onGroup():void
        {
            _inputLabel.visible = true;
            _inputMessage.visible = true;
            _postButton.visible = true;
            _outputBox.visible = true;
        }
        
        private function onConnect():void
        {
            
        }
        
        private function post():void
        {
            if (!_inputMessage.text) return;
            
            var message:Object = { };
            message.user = _userName;
            message.text = _inputMessage.text;
            _connection.doPost(message);
            
            _inputMessage.text = '';
            
            onPosting(message);
        }
        
        
    }
    
}



import flash.events.NetStatusEvent;
import flash.net.GroupSpecifier;
import flash.net.NetConnection;
import flash.net.NetGroup;

class PearAssistGroup
{
    private static var _sequenceNumber:int = 0;
    
    private var _group:NetGroup;
    private var _spec:GroupSpecifier;
    private var _connection:NetConnection;
    
    private var _onPosting:Function;
    
    
    public function get onPosting():Function { return _onPosting; }
    public function set onPosting(value:Function):void { _onPosting = value; }
    
    
    public function PearAssistGroup() 
    {
        
    }
    
    public function doConnect(connection:NetConnection, groupName:String):void
    {
        _connection = connection;
        
        _spec = new GroupSpecifier(groupName);
        _spec.postingEnabled = true;
        _spec.serverChannelEnabled = true;
        
        _group = new NetGroup(connection, _spec.toString());
        _group.addEventListener(NetStatusEvent.NET_STATUS, onNetStatusHandler);
    }
    
    
    
    private function onNetStatusHandler(event:NetStatusEvent):void 
    {
        switch(event.info.code)
        {
            case 'NetGroup.Neighbor.Connect' : 
                _sequenceNumber++;
                break;
            case 'NetGroup.Posting.Notify' : 
                onPostingCallback(event.info.messageID, event.info.message);
                break;
        }
        
    }
    
    public function doPost(message:Object):void
    {
        message.sequence = _sequenceNumber++;
        message.sender = _connection.nearID;
        
        _group.post(message);
    }
    
    private function onPostingCallback(messageID:String, message:Object):void
    {
        if (_onPosting is Function) _onPosting(message);
    }
    
}

import flash.events.AsyncErrorEvent;
import flash.events.IOErrorEvent;
import flash.events.NetStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.net.GroupSpecifier;
import flash.net.NetConnection;
import flash.net.NetGroup;

class PearAssistConnection 
{
    public static const SERVER    : String = 'rtmfp://p2p.rtmfp.net/';
    public static const GROUPNAME : String = 'com.seyself.p2p.test';
    
    //書き換えてね
    public static const DEVKEY    : String = '263f91bdac6be3ec356b51db-e249f567ad93';
    
    private var _connection:NetConnection;
    private var _group:PearAssistGroup;
    
    private var _onConnect:Function;
    private var _onGroup:Function;
    private var _onPosting:Function;
    
    
    public function get onConnect():Function { return _onConnect; }
    public function set onConnect(value:Function):void { _onConnect = value; }
    
    public function get onGroup():Function { return _onGroup; }
    public function set onGroup(value:Function):void { _onGroup = value; }
    
    public function get onPosting():Function 
    {
        if (_group) return _group.onPosting;
        return _onPosting;
    }
    public function set onPosting(value:Function):void
    {
        if (_group) _group.onPosting = value;
        else _onPosting = value;
    }
    
    
    
    public function PearAssistConnection() 
    {
        _connection = new NetConnection();
        _connection.addEventListener(AsyncErrorEvent.ASYNC_ERROR, onAsyncErrorHandler);
        _connection.addEventListener(IOErrorEvent.IO_ERROR, onIOErrorHandler);
        _connection.addEventListener(NetStatusEvent.NET_STATUS, onNetStatusHandler);
        _connection.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onSecurityErrorHandler);
    }
    
    public function doConnect():void
    {
        _connection.connect(SERVER + DEVKEY + '/');
    }
    
    public function doPost(message:Object):void
    {
        _group.doPost(message);
    }
    
    private function onConnectCallback():void
    {
        _group = new PearAssistGroup();
        _group.onPosting = _onPosting;
        _group.doConnect(_connection, GROUPNAME);
    }
    
    
    private function onGroupCallback():void
    {
        if (_onGroup is Function) _onGroup();
    }
    
    private function onSecurityErrorHandler(event:SecurityErrorEvent):void 
    {
        
    }
    
    private function onNetStatusHandler(event:NetStatusEvent):void 
    {
        switch(event.info.code)
        {
            case 'NetConnection.Connect.Success' :
                onConnectCallback();
                break;
            case 'NetGroup.Connect.Success' : 
                onGroupCallback();
                break;
            case 'NetGroup.Connect.Failed' : 
            case 'NetGroup.Connect.Rejected' : 
            case 'NetGroup.Connect.Closed' : 
                break;
            
        }
        
    }
    
    private function onIOErrorHandler(event:IOErrorEvent):void 
    {
        
    }
    
    private function onAsyncErrorHandler(event:AsyncErrorEvent):void 
    {
        
    }
    
}