/**
 * Copyright hiro_rec ( http://wonderfl.net/user/hiro_rec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/njN8
 */

package
{
	import flash.display.*;
	import flash.events.Event;
	import flash.filters.*;
	import flash.geom.*;

	[SWF (backgroundColor='#EEEEEE', frameRate=30)]
	
	public class Main extends Sprite
	{
		private var container:Sprite;
		private var circle:Sprite;
		private var bmd:BitmapData;
		private var bmp:Bitmap;
		
		
		public function Main()
		{
			initDisplay();
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function initDisplay():void
		{
			container = new Sprite();
			
			circle = new Sprite()
			circle.graphics.beginFill(0x1F00FF)
			circle.graphics.drawCircle(0, 0, 30);
			circle.x = mouseX;
			circle.y = mouseY;
			container.addChild(circle);
			
			bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			bmp = new Bitmap();
			bmp.bitmapData = bmd;
			bmp.blendMode = BlendMode.HARDLIGHT;
			addChild(bmp);
		}
		
		private function enterFrameHandler(event:Event):void
		{
			bmd.draw(container);
			
			circle.x = mouseX;
			circle.y = mouseY;
			
			var point:Point = new Point();
			
			bmd.threshold(bmd, bmd.rect, point, "<", 0xFF1FFFFF, 0x00000000, 0x003000FF, true);
			
			bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x0000FF, 1, 20, 20, 10));
			bmd.applyFilter(bmd, bmd.rect, point, new BevelFilter(4, -45, 100000, 1, 0, 0));
			bmd.applyFilter(bmd, bmd.rect, point, new BlurFilter(2, 2));
			bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x0000FF, 1, 10, 10, 10));
			bmd.applyFilter(bmd, bmd.rect, point, new BevelFilter(4, -45, 0, 0.5, 3000000, 0.4, 4, 4, 1.5, 1));
			bmd.applyFilter(bmd, bmd.rect, point, new DropShadowFilter(4, 45, 0, 0.8, 7, 7));
		}
	}
}
