/**
 * Copyright lzjnsn ( http://wonderfl.net/user/lzjnsn )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/njDh
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	public class BallFollowingMouse extends Sprite {
		private var ballCount:uint = 50;
		private var speed:Number = 0.2;
		
		//コンストラクタ
		public function BallFollowingMouse() {
			for( var i:uint = 0; i < ballCount; i++ ) {
				addChild( new Ball( this, 200 ) );
			}
			
			addEventListener( Event.ENTER_FRAME, followMouse );
			
			//テスト用
			var _txt:TextField = new TextField();
			addChild( _txt );
			_txt.autoSize = TextFieldAutoSize.LEFT;
			//toString()メソッドの呼び出し
			_txt.text = new BallEvent( BallEvent.FOLLOW, 0, 1, 2 ).toString();
		}
		
		private function followMouse( eventObject:Event ):void {
			//カスタムイベントを配信する
			//
			//先にイベントを登録しておく
			//addEventListener("イベント名" target);
			//イベントを発生させたいタイミングで使う
			//dispatchEvent(new Event("イベント名"));
			dispatchEvent( new BallEvent( BallEvent.FOLLOW, mouseX, mouseY, speed ) );
		}
	}
}


import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;

class Ball extends Sprite {
	
	private var angle:Number;
	private var radius:Number;
	private var sizeRate:Number = 0.1;
	private const deceleration:Number = 0.2;
	
	public function Ball( timeline:Sprite, maxRadius:Number ) {
		var randamRate:Number = Math.random();
		angle = 2 * Math.PI * Math.random();
		radius = maxRadius * randamRate;
		createBall( randamRate );
		
		timeline.addEventListener( BallEvent.FOLLOW, follow );
	}
	
	private function createBall( randamRate:Number ):void {
		var myGraphics:Graphics = graphics;
		myGraphics.beginFill( Math.floor( 0xFFFFFF * randamRate ) + 1 );
		myGraphics.drawCircle( 0, 0, radius * sizeRate );
		alpha = 1 - randamRate;	
	}
	
	private function follow( eventObject:BallEvent ):void {
		var randomRate:Number = Math.random();
		angle += eventObject.speed;
		angle %= Math.PI * 2;
		var nX:Number = eventObject.targetX + radius * Math.cos( angle ) * randomRate;
		var nY:Number = eventObject.targetY + radius * Math.sin( angle ) * randomRate;
		x += ( nX - x ) * deceleration * randomRate;
		y += ( nY - y ) * deceleration * randomRate;
	}
	
}

class BallEvent extends Event {
	public static const FOLLOW:String = "follow";
	private var _targetX:Number;
	private var _targetY:Number;
	private var _speed:Number;
	
	public function get targetX():Number {
		return _targetX;
	}
	public function get targetY():Number {
		return _targetY;
	}
	public function get speed():Number {
		return _speed;
	}
	
	public function BallEvent( event_str:String, myTargetX:Number, myTargetY:Number, mySpeed:Number ) {
		super( event_str );
		_targetX = myTargetX;
		_targetY = myTargetY;
		_speed = mySpeed;
	}
	
	public override function toString():String {
		//メソッドのオーバーライド
		return formatToString( "BallEvent", "type", "bubbles", "cancelable", "eventPhase", "targetX", "targetY", "speed" );
	}
}