/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nitF
 */

// GraphicsのdrawPath()を使ってみたかった
//
// HSVの色変換についてこちらから一部お借りしました
// http://tail.s68.xrea.com/blog/2006/09/flashrgbhsvhsb.html
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GraphicsPathCommand;
	import flash.display.Shape;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    public class FlashTest extends Sprite {
    public function FlashTest() {
			addEventListener(Event.ENTER_FRAME, enterframeHandler);
			bmpdata = new BitmapData(465, 465, false, 0xFFFFFF);
			addChild(new Bitmap(bmpdata));
			src = new Shape();
        }
		private var src:Shape;
		private var color:uint;
		private var count:Number = 0;
		private var bmpdata:BitmapData;
		private function enterframeHandler(e:Event):void
		{
			count++;
			color = toRGB(count % 360, 100, Math.sin(count * 3.14 / 180*3) * 25 + 75);
			var size:Number = 80;
			var commands:Vector.<int> = new Vector.<int>();
			commands.push(GraphicsPathCommand.MOVE_TO, GraphicsPathCommand.LINE_TO, GraphicsPathCommand.LINE_TO);
			var data:Vector.<Number> = new Vector.<Number>();
			for (var i:int = 0; i < 6; i++)
				data.push((Math.random() - 0.5) * size);
			src.graphics.clear();
			src.graphics.beginFill(color);
			src.graphics.drawPath(commands, data);
			src.graphics.endFill();
			var m:Matrix = new Matrix();
			var x:Number = Math.random() * 465 * 3 / 4;
			var y:Number = Math.random() * 465;
			m.translate(x, y);
			bmpdata.draw(src, m);
			
			color = toRGB(count % 360 + 180, 100, Math.sin(count * 3.14 / 180*3) * 25 + 75);
			src.graphics.clear();
			src.graphics.beginFill(color);
			src.graphics.drawPath(commands, data);
			src.graphics.endFill();
			m.identity();
			m.scale( -1, 1);
			m.translate(465 - x, y);
			bmpdata.draw(src, m);
		}
		private function toRGB(H:Number, S:Number, V:Number):uint
		{
			const RGB_MAX:uint = 0xFF;
			const H_MAX:Number = 360;
			const SV_MAX:Number = 100;
			if (H > H_MAX) H = H_MAX;
			else if (H < 0) H = 0;
			if (S > SV_MAX) S = SV_MAX;
			else if (S < 0) S = 0;
			if (V > SV_MAX) V = SV_MAX;
			else if (V < 0) V = 0;
			
			var r:uint;
			var g:uint;
			var b:uint;
			if (S == 0) {
				r = g = b = V * RGB_MAX / SV_MAX;
			}else {
				var hi:Number = Math.floor(H / (H_MAX / 6)) % 6;
				var f:Number = H / (H_MAX / 6) - hi;
				var w:Number = V / SV_MAX * RGB_MAX;
				var p:Number = w * ( 1 - S / SV_MAX );
				var q:Number = w * ( 1 - S / SV_MAX  * f);
				var t:Number = w * ( 1 - S / SV_MAX  * ( 1 - f));
				switch (hi) { 
				case 0 : 
					r = w; g = t; b = p;
					break; 
				case 1 : 
					r = q; g = w; b = p;
					break; ;
				case 2 : 
					r = p; g = w; b = t;
					break; 
				case 3 : 
					r = p; g = q; b = w;
					break; 
				case 4 : 
					r = t; g = p; b = w;
					break; 
				case 5 : 
					r = w; g = p; b = q;
					break; 
				}
			}
			return r * 0x010000 + g * 0x000100 + b * 0x000001;
		}
    }
}