/**
 * Copyright KebruzMeduza ( http://wonderfl.net/user/KebruzMeduza )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nis4
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import idv.cjcat.stardust.twoD.emitters.Emitter2D;
    [SWF(width = "970", height = "414", framerate="30")]
    public class Main extends Sprite {
        private var scene:Sprite = new Sprite;        
        private var emitter:Emitter2D;        
        public function Main():void {
            emitter = new RainEmitter(scene);            
            addChild(scene);     
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        private function enterFrameHandler(e:Event):void {
            emitter.step();
        }
    }
}

import flash.display.*;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import idv.cjcat.stardust.common.actions.Die;
import idv.cjcat.stardust.common.actions.triggers.ActionTrigger;
import idv.cjcat.stardust.common.clocks.SteadyClock;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Oriented;
import idv.cjcat.stardust.twoD.actions.RandomDrift;
import idv.cjcat.stardust.twoD.actions.triggers.ZoneTrigger;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.handlers.DisplayObjectHandler;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.RectZone;
import idv.cjcat.stardust.twoD.zones.Zone;

class Rain extends Shape {    
    public function Rain() {
        graphics.beginFill(0x303030);
        graphics.drawRect( -1, -15, 6, 35);        
        filters = [new BlurFilter(40, 0)];
    }
}

class RainEmitter extends Emitter2D {    
    public function RainEmitter(container:DisplayObjectContainer) {
        super(new SteadyClock(15));
        addInitializer(new DisplayObjectClass(Rain));
        addInitializer(new Position(new RectZone(1000, -50, 1, 1000)));
        addInitializer(new Scale(new UniformRandom(1, 0.7)));        
        var lazyRectZone:LazySectorZone = new LazySectorZone();
        lazyRectZone.direction.set(-1, 0);
        lazyRectZone.directionVar = 20;
        lazyRectZone.radius = 25;
        lazyRectZone.radiusVar = 15;
        addInitializer(new Velocity(lazyRectZone));
        addAction(new Move());
        addAction(new Oriented());
        addAction(new RandomDrift(6, 4));        
        var gravity:Gravity = new Gravity();
        gravity.addField(new UniformField(-2, 1));
        addAction(gravity);        
        var deathZone:Zone = new RectZone( -50, -50, 1020, 464);
        var zoneTrigger:ActionTrigger = new ZoneTrigger(deathZone);
        zoneTrigger.inverted = true;
        zoneTrigger.addAction(new Die());
        addAction(zoneTrigger);
        particleHandler = new DisplayObjectHandler(container);
    }
}