/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nicV
 */

package {
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite {
        
        private var _sound:PlaySound;
        private var _label:Label;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _label = new Label(stage, 0, 0, "play");
            
            _sound = new PlaySound("http://www.takasumi-nagai.com/soundfiles/sound007.mp3", 10, 0.2);
            stage.addEventListener(MouseEvent.CLICK, StopEventHandler);
        }
        
        private function StopEventHandler(e:MouseEvent):void 
        {
            _sound.pause();
            _label.text = "pause";
            stage.removeEventListener(MouseEvent.CLICK, StopEventHandler);
            stage.addEventListener(MouseEvent.CLICK, RestartEventHandler);
        }
        
        private function RestartEventHandler(e:MouseEvent):void 
        {
            _sound.restart();
            _label.text = "play";
            stage.removeEventListener(MouseEvent.CLICK, RestartEventHandler);
            stage.addEventListener(MouseEvent.CLICK, StopEventHandler);
        }
    }
}

    
    /*
     * SoundChannelに一時停止とリスタートないので作って見ました。
     * 勘違いならごめんなさい。
     * ご指摘あれば、なんなりと。
     * 
     * TODO 他に必要なものがあるかどうか考えて実装する
     */
    
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    
    class PlaySound
    {
        
    private var _sound:Sound;
    private var _count:int;
    private var _vol:Number;
    private var _channel:SoundChannel;
    private var _position:Number;

        public function PlaySound(url:String, count:int = 1, vol:Number = 0.3)
        {
            _sound = new Sound();
            _count = count;
            _vol = vol;
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            _sound.addEventListener(Event.COMPLETE, SoundLoadComplete);
            _sound.load(new URLRequest(url), _context);
            _channel = new SoundChannel();
        }
        
        private function SoundLoadComplete(e:Event):void 
        {
            _position = 0;
            _channel = _sound.play(_position, _count, new SoundTransform(_vol, 0));
            _sound.removeEventListener(Event.COMPLETE, SoundLoadComplete);
        }
        
        public function stop():void
        {
            _channel.stop();
            _position = 0;
        }
        
        public function pause():void
        {
            _position = _channel.position;
            _channel.stop();
        }
        
        public function restart():void
        {
            _channel = _sound.play(_position, _count, new SoundTransform(_vol, 0));
        }
        
        public function reset():void
        {
            _position = 0;
        }
        
        public function set count(value:int):void 
        {
            _count = value;
        }
        
        public function set vol(value:Number):void 
        {
            _vol = value;
        }
    }