/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nibq
 */

package { 
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import com.bit101.components.Window;
    
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ShaderFilter;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]
    public class RayLight extends Sprite {
    
        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------
        public var loaderShader : URLLoader = new URLLoader;
        
        private var shader:Shader = new Shader();
        private var player:VideoPlayer;
        private var filter:ShaderFilter;
        private var _range:Number = .05;
        
        public function RayLight() {
            graphics.beginFill(0, 1);
            graphics.drawRect(0, 0, 465, 465);            
            graphics.endFill()
            loaderShader.addEventListener(Event.COMPLETE, shaderLoaded);
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.load(new URLRequest("http://www.bongiovi.tw/wonderfl/Pixelate10.pbj"));
        }
        
        
        private function shaderLoaded(e:Event) : void {
            shader.byteCode = ByteArray(loaderShader.data);
            
            player = new VideoPlayer(stage.stageWidth, stage.stageHeight);
            player.setVideoURL("http://www.bongiovi.tw/experiments/particleVideo/SigurRos.flv");
            player.play();
            player.setVolume(0);
            addChild(player);
            
            filter = new ShaderFilter(shader);
            player.filters = [filter];
            
            var window:Window = new Window(this, 5, 5, "CONTROLS");
            window.width = 175;
            window.height = 60;
            window.hasMinimizeButton = true;
            new Label(window.content, 5, 0, "RANGE");
            new HSlider(window.content, 50, 5, function(e:Event) : void {
                _range = HSlider(e.currentTarget).value / 1000 + 0.05;
            });
            new Label(window.content, 5, 20, "VOLUME");
            new HSlider(window.content, 50, 25, function(e:Event) : void {
                player.setVolume(HSlider(e.currentTarget).value/100);
            });
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event) : void {
            shader.data.range.value = [_range];
            shader.data.center.value = [stage.mouseX, stage.mouseY];
            player.filters = [filter];
        }
    }
}



import flash.display.Sprite;
import flash.events.AsyncErrorEvent;
import flash.events.ErrorEvent;
import flash.events.NetStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.media.SoundTransform;
import flash.media.Video;
import flash.net.NetConnection;
import flash.net.NetStream;


class VideoPlayer extends Sprite {
    private var _nc:NetConnection;
    private var _ns:NetStream;
    private var _video:Video;
    private var _url:String;
    public function VideoPlayer(width:int, height:int) {
        _nc = new NetConnection();
        _nc.addEventListener(NetStatusEvent.NET_STATUS, onStatus);
        _nc.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError);
        _nc.connect(null);
        
        _ns = new NetStream(_nc);
        _ns.client = this;
        _ns.addEventListener(NetStatusEvent.NET_STATUS, onStatus);
        _ns.addEventListener(AsyncErrorEvent.ASYNC_ERROR, onError);
        _ns.checkPolicyFile = true;
        
        _video = new Video(width, height);
        _video.smoothing = true;
        _video.attachNetStream(_ns);
        addChild(_video);
    }
    
    
    public function setVideoURL(videoURL:String):void {
        _url = videoURL;
        stop();
    }
    
    
    public function play():void {
        if (!_url)  {
            stop();
            trace("No URL set. Please use the 'setVideoURL' method.");
        } else {
            _ns.play(_url);
        }
    }
    
    
    public function stop():void {
        _ns.close();
        _video.clear();
    }
    
    
    public function setVolume(volume:Number):void {
        var st:SoundTransform = _ns.soundTransform;
        st.volume = volume;
        _ns.soundTransform = st;
    }
    
    private function onError(e:ErrorEvent) : void { trace(e.text);    }
    
    private function onStatus(e:NetStatusEvent) : void {    trace(e.info.code);    }
    
    public function onMetaData(o:Object):void { }
    
    public function onXMPData(info:Object):void { }
}

/*


<languageVersion : 1.0;>

kernel RayLight
<   namespace : "bongiovi.tw";
    vendor : "bongiovi";
    version : 1;
    description : "RayLight Effect";
>
{
    input image4 src;         
    output pixel4 dst;
     
    parameter float2 center
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(1000.0, 1000.0);
        defaultValue:float2(300.0, 200.0);
    >;                                           
    
    
    parameter float range
    <
        minValue:0.0;
        maxValue:3.0;
        defaultValue:0.05;
    >;             
    
    
    parameter int isBW
    <
        minValue:0;
        maxValue:1;
        defaultValue:0;
    >;
    
    
    
    #define getBrightness(color) (color.r*color.r + color.g*color.g + color.b*color.b) / 3.0
    
    void
    evaluatePixel()
    {
        float2 pos = outCoord();
        float2 newPos = pos - center;      
        float theta = atan(newPos.y, newPos.x);       
        float r = length(newPos);
        float thetaCenter = floor(theta/range) * range + range*.5;
        float2 pos0 = float2(cos(thetaCenter)*r+center.x, sin(thetaCenter)*r+center.y);
        float4 color = sampleLinear(src, pos0);
        float bright = getBrightness(color);    
        if(abs(theta - thetaCenter) > range * .5 * bright) color.a = 0.0;
        
        if(isBW > 0) color.r = color.g = color.b = (color.r + color.g + color.b) / 3.0;
        
        dst = color;
    }
}


*/