/**
 * Copyright hacker_u_yjm2r7 ( http://wonderfl.net/user/hacker_u_yjm2r7 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/niZX
 */

// forked from nitoyon's convert bloggie(PM-5K) 360 degree photo
package{
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.system.LoaderContext;
import flash.net.*;

public class Test extends Sprite{
    private const R2:Number = 690;
    private const R1:Number = 180;
    private const W:Number = 2000;

    public function Test() {
        // load image
        var loader:Loader = new Loader();
        var context:LoaderContext = new LoaderContext(true);
        loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/9/95/9590/9590f390ef8b358e16b443d9838802d57d047fe0"), context);
        loader.contentLoaderInfo.addEventListener("complete", loadCompleteHandler);

        // start text
        var t:TextField = new TextField();
        t.text = "LOADING...";
        addChild(t);
    }

    private function loadCompleteHandler(event:Event):void {
        // copy bitmap to BitmapData
        var loaderInfo:LoaderInfo = LoaderInfo(event.target);
        var bmd:BitmapData = new BitmapData(loaderInfo.width, loaderInfo.height);
        bmd.draw(loaderInfo.loader);

        // get size information
        var w:Number = bmd.width;
        var h:Number = bmd.height;
        w -= 64; h += 15;

        var preview:Sprite = Sprite(addChild(new Sprite()));

        // show BitmapData
        var originalBmp:Bitmap = Bitmap(preview.addChild(new Bitmap(bmd)));
        originalBmp.scaleX = originalBmp.scaleY = .15;
        originalBmp.y = 120;

        // converting line
        var pos:Sprite = new Sprite();
        pos.graphics.lineStyle(2, 0xff0000);
        pos.graphics.moveTo(R1, 0);
        pos.graphics.lineTo(R2, 0);
        pos.scaleX = pos.scaleY = originalBmp.scaleX;
        pos.x = originalBmp.width / 2;
        pos.y = originalBmp.height / 2 + originalBmp.y;
        preview.addChild(pos);

        // init convert target BitmapData
        var bmd2:BitmapData = new BitmapData(W, R2 - R1, false, 0xff808080);
        var bmp2:Bitmap = Bitmap(preview.addChild(new Bitmap(bmd2)));
        bmp2.scaleX = bmp2.scaleY = .2;

        var counter:int = 0;
        addEventListener("enterFrame", function(event:Event):void {
            if (counter < W){
                // convert to polar coordinates
                for (var i:int = 0; i < 10; i++){
                    var rad:Number = 2 * Math.PI / W * -counter;
                    pos.rotation = rad / Math.PI * 180;
                    var cos:Number = Math.cos(rad);
                    var sin:Number = Math.sin(rad);

                    bmd2.lock();
                    for (var j:int = 0; j <= R2 - R1; j++){
                        var xx:int = w / 2 + (j + R1) * cos;
                        var yy:int = h / 2 + (j + R1) * sin;
                        bmd2.setPixel(counter, j, bmd.getPixel(xx, yy));
                    }
                    bmd2.unlock();
                    counter++;
                }
            } else if (counter <= W + 30) {
                // change scale
                bmp2.scaleX = bmp2.scaleY = (counter - W) / 30.0 * .7 + .2;

                // finish handler
                if (counter == W + 30) {
                    var bmp3:Bitmap = Bitmap(preview.addChild(new Bitmap(bmd2)));
                    bmp3.scaleX = bmp3.scaleY = bmp2.scaleX;
                    bmp3.x = bmp2.width;
                }

                counter++;
            } else {
                // finished
                preview.x += (stage.stageWidth / 2 - stage.mouseX) / 10 - bmp2.width;
                preview.x %= bmp2.width;
            }
        });
    }
}
}
