/**
 * Copyright norichika2 ( http://wonderfl.net/user/norichika2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/niLk
 */

package 
{
	import flash.events.Event;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.materials.*;

	public class Main extends BasicView
	{
		//3Dオブジェクト作成
		private var Obj3d:DisplayObject3D;
		
		//球体作成
		private var sphere1:Sphere
		private var sphere2:Sphere
		
		//円周
		var rot:Number = 0;
		
		public function Main() 
		{
			
			//ワイヤーマテリアル作成
			var material1:WireframeMaterial = new WireframeMaterial(0x0099FF);
			
			//コンポジットマテリアル作成
			var material:CompositeMaterial = new CompositeMaterial();
			material.addMaterial( new ColorMaterial(0xFFFF99) );
			material.addMaterial( new WireframeMaterial(0xFFFFFF) );
			
			//球体作成
			sphere1 = new Sphere(material1, 200, 20, 20);
			sphere2 = new Sphere(material, 100, 8, 6);
			
			//3Dオブジェクト作成
			Obj3d = new DisplayObject3D;
			scene.addChild(Obj3d);
			
			
			Obj3d.addChild(sphere1);
			Obj3d.addChild(sphere2);
			
			//球体ななめに傾ける
			sphere1.localRotationZ = 45;
			sphere2.localRotationZ = 30;
			
			startRendering();
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			rot++;
			if (rot == 360)
			{
				rot = 0;
			}
			
			//円周の動き
			sphere2.x = 600 * Math.sin(rot * Math.PI / 180);
			sphere2.z = 600 * Math.cos(rot * Math.PI / 180);
			
			sphere1.localRotationY += 1;
			sphere2.localRotationY += 1;
			
		}
		
	}

}