/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nhyn
 */

// forked from nanki's circumcenter
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.BlendMode;
	[SWF(width = "465", height = "465", backgroundColor = 0xFFFFFF, frameRate = "60")]
  public class CircumCenter extends Sprite {
	 private var W:Number = 465
	 private var H:Number = 465

    public function CircumCenter() {

		var num:uint = 5;
		var i:uint;
		for (i = 0; i < num; i++) addChild(new Circle(W, H));
		
		var bmd:BitmapData = new BitmapData(W, H,false, 0x00000000);
		addChild(new Bitmap(bmd));

		
		addEventListener(Event.ENTER_FRAME, function ():void 
		{
			bmd.fillRect(bmd.rect, 0x0);
			for (i = 0; i < num; i++)
			{
				var c:Circle = Circle(getChildAt(i));
				bmd.draw(c, null, null , BlendMode.SCREEN);
			}
		});
	}
  }
}

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.events.Event;
import flash.geom.*;
class Circle
extends Sprite
{
	public function Circle(w:Number, h:Number):void 
	{
      var p:Vector.<Particle> = new Vector.<Particle>(3);

      for (var i:int = 0; i < 3; i++) {
        addChild(p[i] = new Particle(w, h));
      }
	  var clr:uint = Math.random() * 0xFFFFFF;

      addEventListener(Event.ENTER_FRAME, function():void {
        var a:Vector3D = new Vector3D(p[0].x, p[0].y);
        var b:Vector3D = new Vector3D(p[1].x, p[1].y);
        var c:Vector3D = new Vector3D(p[2].x, p[2].y);

        var ab:Vector3D = b.subtract(a);
        var bc:Vector3D = c.subtract(b);
        var ca:Vector3D = a.subtract(c);

        var c2:Number = ab.lengthSquared;
        var a2:Number = bc.lengthSquared;
        var b2:Number = ca.lengthSquared;

        var s:Number = 2 / ab.crossProduct(bc).length;

        var _a:Vector3D = a.clone();
        var _b:Vector3D = b.clone();
        var _c:Vector3D = c.clone();

        _a.scaleBy(a2 * (b2 + c2 - a2));
        _b.scaleBy(b2 * (c2 + a2 - b2));
        _c.scaleBy(c2 * (a2 + b2 - c2));

        var q:Vector3D = _a;
        q.incrementBy(_b);
        q.incrementBy(_c);
        q.scaleBy(s * s / 16);

        graphics.clear();
        graphics.beginFill(clr);
        graphics.drawCircle(q.x, q.y, q.subtract(a).length);
        graphics.endFill();		
      });
    }
}
import caurina.transitions.Tweener;
class Particle 
extends Sprite {
	
 private var W:Number
 private var H:Number
  public function Particle(w_:Number, h_:Number) {
	  W = w_;
	  H = h_;
	x: Math.random() * W;
	y:Math.random() * H;
	
    graphics.beginFill(0,0.5);
    graphics.drawCircle(0,0,3);
    graphics.endFill();
	
	startTween();
	
  }
  private function startTween():void 
  {
	Tweener.addTween(this, {
	x: Math.random() * W,
	y:Math.random() * H,
	time:Math.random() * 3 + 1,
	transition:"linear",
	onComplete: startTween
	});
	  
  }
}
