/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nhsK
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(width = "480", height = "480", backgroundColor = "0xffffff",frameRate="60")] 
	public class Practice68 extends Sprite {
		private var bmp:BitmapData;
		private var list:Array;
		private var id:int;
		private var px:int, py:int, rad:Number,deg:Number;
		
		public function Practice68() {
			bmp = new BitmapData(480, 480, true, 0xffffffff);
			addChild(new Bitmap(bmp));
			list = new Array();
			rad = 200.0;
			deg = 0.0;
			addEventListener(Event.ENTER_FRAME,update);
		}
		
		private function update(e:Event):void {
			id = (id + 6) % 360;
			deg += 0.05+mouseX / 480.0;
			rad = 140*mouseY / 480.0;
			px = 240 + Math.cos(deg) * rad;
			py = 240 + Math.sin(deg) * 140;
			var c:Circle = new Circle(px, py, getColor(id, 1.0));
			addChild(c);
			list.push(c);
			for (var i:int = 0; i < list.length; i++) {
				c = list.shift();
				c.update(bmp);
				if (c.alpha > 0.05) {
					list.push(c);				
				}else {
					removeChild(c);
				}
			}
		}
		
		private function getColor(i:int, saturation:Number):uint {
			var value:Number = 1.0;
			var h:Number = i / 60;
			var ii:Number = Math.floor(h);
			var ff:Number = h - ii;
			var p1:Number = value * (1.0 - saturation);
			var p2:Number = value * (1.0 - saturation * ff);
			var p3:Number = value * (1.0 - saturation * (1.0 - ff));
			var rv:Number;
			var gv:Number;
			var bv:Number;
			switch(ii) {
			case 0:
				rv = value, gv = p3, bv = p1;
				break;
			case 1:
				rv = p2, gv = value, bv = p1;
				break;
			case 2:
				rv = p1, gv = value, bv = p3;
				break;
			case 3:
				rv = p1, gv = p2, bv = value;
				break;
			case 4:
				rv = p3, gv = p1, bv = value;
				break;
			default:
				rv = value, gv = p1, bv = p2;
			}
			var rr:int = Math.max(0, Math.min(255, rv * 255));
			var gg:int = Math.max(0, Math.min(255, gv * 255));
			var bb:int = Math.max(0, Math.min(255, bv * 255));
			var color:uint = (rr << 16) + (gg << 8) + bb;
			return color;
		}
	}
}
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.MovieClip;

class Circle extends MovieClip {
	private var rad:Number = 1.0;
	private var color:uint;
	
	public function Circle(_x:Number,_y:Number,_c:Number):void {
		this.x = _x;
		this.y = _y;
		this.color = _c;
	}
	
	public function update(b:BitmapData):void {
		this.alpha *= 0.96;
		rad *= 1.1;
		this.graphics.clear();
		this.graphics.beginFill(color);
		this.graphics.drawCircle(0, 0, rad);
		this.graphics.endFill();
	}
	
}