/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nhIR
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=465,height=465,backgroundColor=0x000000,frameRate=30)]
	public class Main extends Sprite {
		
		private const SW:Number = stage.stageWidth;
		private const SH:Number = stage.stageHeight;
		private var hNum:uint = 50;
		private var vNum:uint = 50;
		private var noise:Texture;
		private var smoke:Sprite;
		
		public function Main():void {
			noise = new Texture(hNum, vNum);
			addEventListener(Event.ENTER_FRAME, xRun);
			// 検証用
			var bm:Bitmap = new Bitmap(noise);
			addChild(bm);
			// 煙になるかな？
			smoke = new Sprite();
			smoke.x = SW/2;
			smoke.y = SH;
			addChild(smoke);
		}
		
		private function xRun(e:Event):void {
			// Noiseを動かして（Point値を更新）
			noise.xDraw(1,1);
			// Noiseから座標を取得して煙の祖片を描画
			smoke.graphics.clear();
			for (var v:uint = 0; v < 10; v++) {
				var nX:Number = 0;
				var nY:Number = 0;
				smoke.graphics.lineStyle(0,0xffffff,0.2);
				smoke.graphics.moveTo(nX,nY);
				for (var h:uint = 0; h < 40; h++) {
					var nColor:uint = noise.getPixel(v,h);
					var colors:Array = toRGB(nColor);
					nX += (colors[1]-128)/15;
					nY += (colors[2]-128)/10 - 10;
					smoke.graphics.lineTo(nX,nY);
				}
			}
		}
		private function toRGB(nColor:uint):Array {
			var nB:uint = nColor & 0xff;
			var nG:uint = (nColor >> 8) & 0xff;
			var nR:uint = (nColor >> 16) & 0xff;
			return ([nR, nG, nB]);
		}
	}
}

import flash.display.*;
import flash.geom.*;
class Texture extends BitmapData {
	public var point:Point = new Point(0,0);
	private var seed:uint = Math.floor(Math.random() * 10);
	private var channels:uint = BitmapDataChannel.GREEN | BitmapDataChannel.BLUE;
	public function Texture (w:uint=200, h:uint=200) {
		super(w, h, true, 0xffffffff);
	}
	public function xDraw(pX:Number, pY:Number):void {
		point.x += pX;
		point.y += pY;
		perlinNoise(40, 40, 4, seed, false, true, channels, false, [point]);
	}
}